/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.enums.InOutTypeEnum;
import com.ejianc.business.storecloud.mapper.WarehouseSurplusMapper;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.business.storecloud.vo.WarehouseSurplusQueryVO;
import com.ejianc.business.storecloud.vo.WarehouseSurplusVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="warehouseSurplusService")
public class WarehouseSurplusServiceImpl
extends BaseServiceImpl<WarehouseSurplusMapper, WarehouseSurplusEntity>
implements IWarehouseSurplusService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IWarehouseService warehouseService;
    @Autowired
    private IWarehouseFlowService warehouseFlowService;

    @Override
    public CommonResponse<String> updateStoreSurplusIn(WarehouseManageVO manageVO, boolean isSave) {
        Integer type = manageVO.getType() == null ? -1 : manageVO.getType();
        List flowVOList = manageVO.getFlowVOList();
        List materialList = flowVOList.stream().map(WarehouseFlowVO::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WarehouseSurplusEntity::getProjectId, (Object)manageVO.getProjectId());
        queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)manageVO.getStoreId());
        queryWrapper.in(WarehouseSurplusEntity::getMaterialId, materialList);
        List surplusEntities = this.list((Wrapper)queryWrapper);
        Map<Object, Object> surplusMap = null;
        surplusMap = CollectionUtils.isNotEmpty((Collection)surplusEntities) ? surplusEntities.stream().collect(Collectors.toMap(WarehouseSurplusEntity::getMaterialId, Function.identity(), (key1, key2) -> key2)) : new HashMap();
        for (WarehouseFlowVO warehouseFlowVO : flowVOList) {
            CommonResponse commonResponse;
            WarehouseSurplusEntity surplusEntity = null;
            if (surplusMap.containsKey(warehouseFlowVO.getMaterialId())) {
                surplusEntity = (WarehouseSurplusEntity)((Object)surplusMap.get(warehouseFlowVO.getMaterialId()));
            } else {
                surplusEntity = (WarehouseSurplusEntity)((Object)BeanMapper.map((Object)warehouseFlowVO, WarehouseSurplusEntity.class));
                surplusEntity.setAttachIds(null);
                surplusEntity.setId(IdWorker.getId());
                commonResponse = this.materialApi.queryCategoryById(surplusEntity.getMaterialCategoryId());
                if (commonResponse.isSuccess() && null != commonResponse.getData()) {
                    MaterialCategoryVO categoryVO = (MaterialCategoryVO)commonResponse.getData();
                    surplusEntity.setMaterialCategoryName(categoryVO.getName());
                    surplusEntity.setMaterialCategoryCode(categoryVO.getCode());
                    surplusEntity.setMaterialTypeName(categoryVO.getName());
                    surplusEntity.setMaterialCategoryInnerCode(((MaterialCategoryVO)commonResponse.getData()).getInnerCode());
                }
            }
            if (1 != type) {
                surplusEntity.setInstoreMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getInstoreMny(), (BigDecimal)warehouseFlowVO.getMny()));
                surplusEntity.setInstoreTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getInstoreTaxMny(), (BigDecimal)warehouseFlowVO.getTaxMny()));
            }
            if (2 != type) {
                surplusEntity.setInstoreNum(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)warehouseFlowVO.getNum()));
            }
            surplusEntity.setSurplusMny(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreMny(), (BigDecimal)surplusEntity.getOutLockMny()));
            surplusEntity.setSurplusTaxMny(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreTaxMny(), (BigDecimal)surplusEntity.getOutLockTaxMny()));
            surplusEntity.setSurplusNum(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)surplusEntity.getOutLockNum()));
            if (ComputeUtil.isLessThan((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)surplusEntity.getOutLockNum())) {
                throw new BusinessException("\u7269\u8d44\u3010" + warehouseFlowVO.getMaterialName() + "\u3011\u5df2\u51fa\u5e93\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
            }
            surplusEntity.setSurplusPrice(ComputeUtil.safeDiv((BigDecimal)surplusEntity.getSurplusMny(), (BigDecimal)surplusEntity.getSurplusNum()));
            surplusEntity.setSurplusTaxPrice(ComputeUtil.safeDiv((BigDecimal)surplusEntity.getSurplusTaxMny(), (BigDecimal)surplusEntity.getSurplusNum()));
            if (InOutTypeEnum.\u671f\u521d\u5165\u5e93.getCode().equals(warehouseFlowVO.getInOutType())) {
                this.dealFirstAttachment(isSave, type, warehouseFlowVO, surplusEntity);
            } else if (InOutTypeEnum.\u9a8c\u6536\u5165\u5e93_\u6cb3\u5357.getCode().equals(warehouseFlowVO.getInOutType())) {
                this.dealCheckAttachment(isSave, type, warehouseFlowVO, surplusEntity);
            }
            commonResponse = this.attachmentApi.queryListBySourceId(surplusEntity.getId(), "EJCBT202208000017", "imgUpload", null);
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                List fileIdList = ((List)commonResponse.getData()).stream().map(AttachmentVO::getId).collect(Collectors.toList());
                surplusEntity.setFileIds(StringUtils.join(fileIdList, (String)","));
            } else {
                surplusEntity.setFileIds(null);
            }
            surplusMap.put(warehouseFlowVO.getMaterialId(), (Object)surplusEntity);
        }
        if (!surplusMap.isEmpty()) {
            this.saveOrUpdateBatch(surplusMap.values());
            this.updateWarehouseMny(manageVO);
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u5e93\u5b58\u4f59\u91cf\u6210\u529f");
    }

    private void dealFirstAttachment(Boolean isSave, Integer type, WarehouseFlowVO warehouseFlowVO, WarehouseSurplusEntity surplusEntity) {
        if (isSave.booleanValue()) {
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(warehouseFlowVO.getSourceDetailId()), "EJCBT202208000016", "imgUpload", String.valueOf(surplusEntity.getId()), "EJCBT202208000017", "imgUpload");
        } else {
            CommonResponse commonResponse = this.attachmentApi.queryListBySourceId(warehouseFlowVO.getSourceDetailId(), "BT210816000000002", "imgUpload", null);
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                List fileList = ((List)commonResponse.getData()).stream().map(AttachmentVO::getFileName).collect(Collectors.toList());
                this.attachmentApi.deleteFileByParams(surplusEntity.getId(), "EJCBT202208000017", "imgUpload", fileList);
            }
        }
    }

    private void dealCheckAttachment(Boolean isSave, Integer type, WarehouseFlowVO warehouseFlowVO, WarehouseSurplusEntity surplusEntity) {
        CommonResponse commonResponse;
        if (isSave.booleanValue()) {
            CommonResponse commonResponse2;
            if (2 == type && (commonResponse2 = this.attachmentApi.queryListBySourceId(warehouseFlowVO.getSourceDetailId(), "BT210816000000002", "imgUpload", null)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse2.getData()))) {
                List fileList = ((List)commonResponse2.getData()).stream().map(AttachmentVO::getFileName).collect(Collectors.toList());
                this.attachmentApi.deleteFileByParams(surplusEntity.getId(), "EJCBT202208000017", "imgUpload", fileList);
            }
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(warehouseFlowVO.getSourceDetailId()), "BT210816000000002", "imgUpload", String.valueOf(surplusEntity.getId()), "EJCBT202208000017", "imgUpload");
        } else if (1 == type && (commonResponse = this.attachmentApi.queryListBySourceId(warehouseFlowVO.getSourceDetailId(), "BT210816000000002", "imgUpload", null)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
            List fileList = ((List)commonResponse.getData()).stream().map(AttachmentVO::getFileName).collect(Collectors.toList());
            this.attachmentApi.deleteFileByParams(surplusEntity.getId(), "EJCBT202208000017", "imgUpload", fileList);
        }
    }

    @Override
    public CommonResponse<String> updateStoreSurplusOut(WarehouseManageVO manageVO) {
        List flowVOList = manageVO.getFlowVOList();
        List materialList = flowVOList.stream().map(WarehouseFlowVO::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WarehouseSurplusEntity::getProjectId, (Object)manageVO.getProjectId());
        queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)manageVO.getStoreId());
        queryWrapper.in(WarehouseSurplusEntity::getMaterialId, materialList);
        List surplusEntities = this.list((Wrapper)queryWrapper);
        Map<Object, Object> surplusMap = null;
        surplusMap = CollectionUtils.isNotEmpty((Collection)surplusEntities) ? surplusEntities.stream().collect(Collectors.toMap(WarehouseSurplusEntity::getMaterialId, Function.identity(), (key1, key2) -> key2)) : new HashMap();
        for (WarehouseFlowVO warehouseFlowVO : flowVOList) {
            WarehouseSurplusEntity surplusEntity = null;
            if (!surplusMap.containsKey(warehouseFlowVO.getMaterialId())) {
                throw new BusinessException("\u7269\u8d44\u3010" + warehouseFlowVO.getMaterialName() + "\u3011\u6ca1\u6709\u5165\u5e93!");
            }
            surplusEntity = (WarehouseSurplusEntity)((Object)surplusMap.get(warehouseFlowVO.getMaterialId()));
            surplusEntity.setOutLockMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getOutLockMny(), (BigDecimal)warehouseFlowVO.getMny()));
            surplusEntity.setOutLockTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getOutLockTaxMny(), (BigDecimal)warehouseFlowVO.getTaxMny()));
            surplusEntity.setOutLockNum(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getOutLockNum(), (BigDecimal)warehouseFlowVO.getNum()));
            if (ComputeUtil.isLessThan((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)surplusEntity.getOutLockNum())) {
                throw new BusinessException("\u7269\u8d44\u3010" + warehouseFlowVO.getMaterialName() + "\u3011\u5e93\u5b58\u4e0d\u8db3!");
            }
            surplusEntity.setSurplusMny(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreMny(), (BigDecimal)surplusEntity.getOutLockMny()));
            surplusEntity.setSurplusTaxMny(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreTaxMny(), (BigDecimal)surplusEntity.getOutLockTaxMny()));
            surplusEntity.setSurplusNum(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)surplusEntity.getOutLockNum()));
            surplusEntity.setSurplusPrice(ComputeUtil.safeDiv((BigDecimal)surplusEntity.getSurplusMny(), (BigDecimal)surplusEntity.getSurplusNum()));
            surplusEntity.setSurplusTaxPrice(ComputeUtil.safeDiv((BigDecimal)surplusEntity.getSurplusTaxMny(), (BigDecimal)surplusEntity.getSurplusNum()));
            surplusMap.put(warehouseFlowVO.getMaterialId(), (Object)surplusEntity);
        }
        if (!surplusMap.isEmpty()) {
            this.saveOrUpdateBatch(surplusMap.values());
            this.updateWarehouseMny(manageVO);
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u5e93\u5b58\u4f59\u91cf\u6210\u529f");
    }

    @Override
    public List<WarehouseSurplusVO> queryByStoreMateList(WarehouseSurplusQueryVO queryVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.gt(WarehouseSurplusEntity::getSurplusNum, (Object)0);
        queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)queryVO.getStoreId());
        queryWrapper.in(WarehouseSurplusEntity::getMaterialId, queryVO.getMaterialList());
        List surplusEntities = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)surplusEntities)) {
            return BeanMapper.mapList((Iterable)surplusEntities, WarehouseSurplusVO.class);
        }
        return null;
    }

    private void updateWarehouseMny(WarehouseManageVO manageVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"sum(surplus_tax_mny) as surplusTaxMny"});
        wrapper.eq((Object)"store_id", (Object)manageVO.getStoreId());
        WarehouseSurplusEntity sumEntity = (WarehouseSurplusEntity)((Object)this.getOne((Wrapper)wrapper, false));
        if (null != sumEntity) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(WarehouseEntity::getTotalMny, (Object)sumEntity.getSurplusTaxMny());
            updateWrapper.eq(BaseEntity::getId, (Object)manageVO.getStoreId());
            this.warehouseService.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            ArrayList<WarehouseFlowVO> warehouseFlowVOList = new ArrayList<WarehouseFlowVO>();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                WarehouseFlowVO warehouseFlowVO = new WarehouseFlowVO();
                boolean flag = false;
                String warnType = "";
                ArrayList<String> codeList = new ArrayList<String>();
                codeList.add(((String)datas.get(0)).trim());
                CommonResponse materialList = this.materialApi.queryMaterialListByCodes(codeList);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    warehouseFlowVO.setMaterialCode(null);
                    warnType = warnType + "\u7f16\u53f7\u4e3a\u7a7a,";
                    flag = true;
                } else if (CollectionUtils.isEmpty((Collection)((Collection)materialList.getData()))) {
                    warehouseFlowVO.setMaterialCode((String)datas.get(0));
                    warnType = warnType + "\u7f16\u53f7\u9519\u8bef,";
                    flag = true;
                } else {
                    String materialCode = (String)datas.get(0);
                    warehouseFlowVO.setMaterialCode(materialCode);
                }
                warehouseFlowVO.setMaterialName((String)datas.get(1));
                warehouseFlowVO.setMaterialSpec((String)datas.get(2));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    warehouseFlowVO.setNum(null);
                    warnType = warnType + "\u5e93\u5b58\u6570\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    BigDecimal num = new BigDecimal((String)datas.get(3));
                    warehouseFlowVO.setNum(num);
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    warehouseFlowVO.setTaxMny(null);
                    warnType = warnType + "\u5e93\u5b58\u91d1\u989d\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    BigDecimal taxMny = new BigDecimal((String)datas.get(4));
                    warehouseFlowVO.setTaxMny(taxMny);
                }
                warehouseFlowVO.setImportFlag(Boolean.valueOf(!flag));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                warehouseFlowVO.setWarnType(warnType);
                warehouseFlowVO.setRowState("add");
                warehouseFlowVOList.add(warehouseFlowVO);
            }
            ArrayList successList = new ArrayList();
            ArrayList errorList = new ArrayList();
            if (CollectionUtils.isNotEmpty(warehouseFlowVOList)) {
                warehouseFlowVOList.forEach(vo -> {
                    if (StringUtils.isEmpty((CharSequence)vo.getWarnType())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                });
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size() - 1));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public Object saveImportExcel(String storeId, HttpServletRequest request, List<WarehouseFlowVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> codeList = new ArrayList<String>();
        for (WarehouseFlowVO vo : importVOS) {
            vo.setMaterialCode(vo.getMaterialCode().trim());
            vo.setMaterialName(vo.getMaterialName().trim());
            vo.setMaterialSpec(vo.getMaterialSpec().trim());
            codeList.add(vo.getMaterialCode());
        }
        CommonResponse response = this.materialApi.queryMaterialListByCodes(codeList);
        ArrayList<WarehouseFlowVO> warehouseFlowVOList = new ArrayList<WarehouseFlowVO>();
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            Map map = ((List)response.getData()).stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
            for (WarehouseFlowVO warehouseFlowVO : importVOS) {
                if (!map.containsKey(warehouseFlowVO.getMaterialCode())) continue;
                MaterialVO materialVO = (MaterialVO)map.get(warehouseFlowVO.getMaterialCode());
                warehouseFlowVO.setStoreId(Long.valueOf(storeId));
                warehouseFlowVO.setMaterialCategoryId(materialVO.getCategoryId());
                warehouseFlowVO.setMaterialCategoryName(materialVO.getCategoryName());
                warehouseFlowVO.setMaterialId(materialVO.getId());
                warehouseFlowVO.setMaterialName(materialVO.getName());
                warehouseFlowVO.setMaterialSpec(materialVO.getSpec());
                warehouseFlowVO.setMaterialUnitName(materialVO.getUnitName());
                warehouseFlowVO.setMaterialTypeName(materialVO.getCategoryName());
                warehouseFlowVOList.add(warehouseFlowVO);
            }
        }
        this.warehouseFlowService.saveListForImport(warehouseFlowVOList, Long.valueOf(storeId));
        return "\u4fdd\u5b58\u6210\u529f\uff01";
    }
}

