package com.ejianc.business.sync.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 零星用工实体
 *
 * @author generator
 *
 */
public class OddVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectSourceId; // 项目来源id
    private Long cropId; // 项目所属组织id
    private String cropSourceId; // 项目所属组织来源id
    private Long orgId; // 组织
    private String orgSourceId; // 组织来源id
    private String orgName; // 组织名称
    private String contractId; // 合同
    private String contractName; // 合同名称
    private String contractCode; // 合同编号
    private String supplierId; // 供方主键
    private String supplierName; // 供方名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 单据日期，自己的
    private Long useType; // 用工类型，档案
    private Long belong; // 费用归属，档案
    private String planBody; // 施工部位
    private String useDesc; // 用工内容
    private java.math.BigDecimal useMny; // 用工金额
    private java.math.BigDecimal reviewMny; // 审核金额
    private Integer sourceType; // 来源类型,0-参照申请，1-自制
    private Long oddApplyId; // 用工申请主键
    private String oddApplyBillCode; // 申请单编号
    private Integer oddStatus; // 暂存状态，0-暂存，1-已提交
    private Integer billState; // 单据状态
    private Integer redirectFlag; // 是否转扣，0-否，1-是
    private String createName; // 申请人姓名

    private List<OddInfoVO> oddInfoVos = new ArrayList<>(); // 零星用工申请单实体

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目来源id
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源id
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 项目所属组织id
     */
    public Long getCropId() {
        return cropId;
    }

    /**
     * 项目所属组织id
     */
    public void setCropId(Long cropId) {
        this.cropId = cropId;
    }
    /**
     * 项目所属组织来源id
     */
    public String getCropSourceId() {
        return cropSourceId;
    }

    /**
     * 项目所属组织来源id
     */
    public void setCropSourceId(String cropSourceId) {
        this.cropSourceId = cropSourceId;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织来源id
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源id
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同
     */
    public String getContractId() {
        return contractId;
    }

    /**
     * 合同
     */
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供方主键
     */
    public String getSupplierId() {
        return supplierId;
    }

    /**
     * 供方主键
     */
    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 单据日期，自己的
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 单据日期，自己的
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 用工类型，档案
     */
    public Long getUseType() {
        return useType;
    }

    /**
     * 用工类型，档案
     */
    public void setUseType(Long useType) {
        this.useType = useType;
    }
    /**
     * 费用归属，档案
     */
    public Long getBelong() {
        return belong;
    }

    /**
     * 费用归属，档案
     */
    public void setBelong(Long belong) {
        this.belong = belong;
    }
    /**
     * 施工部位
     */
    public String getPlanBody() {
        return planBody;
    }

    /**
     * 施工部位
     */
    public void setPlanBody(String planBody) {
        this.planBody = planBody;
    }
    /**
     * 用工内容
     */
    public String getUseDesc() {
        return useDesc;
    }

    /**
     * 用工内容
     */
    public void setUseDesc(String useDesc) {
        this.useDesc = useDesc;
    }
    /**
     * 用工金额
     */
    public java.math.BigDecimal getUseMny() {
        return useMny;
    }

    /**
     * 用工金额
     */
    public void setUseMny(java.math.BigDecimal useMny) {
        this.useMny = useMny;
    }
    /**
     * 审核金额
     */
    public java.math.BigDecimal getReviewMny() {
        return reviewMny;
    }

    /**
     * 审核金额
     */
    public void setReviewMny(java.math.BigDecimal reviewMny) {
        this.reviewMny = reviewMny;
    }
    /**
     * 来源类型,0-参照申请，1-自制
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型,0-参照申请，1-自制
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 用工申请主键
     */
    public Long getOddApplyId() {
        return oddApplyId;
    }

    /**
     * 用工申请主键
     */
    public void setOddApplyId(Long oddApplyId) {
        this.oddApplyId = oddApplyId;
    }
    /**
     * 申请单编号
     */
    public String getOddApplyBillCode() {
        return oddApplyBillCode;
    }

    /**
     * 申请单编号
     */
    public void setOddApplyBillCode(String oddApplyBillCode) {
        this.oddApplyBillCode = oddApplyBillCode;
    }
    /**
     * 暂存状态，0-暂存，1-已提交
     */
    public Integer getOddStatus() {
        return oddStatus;
    }

    /**
     * 暂存状态，0-暂存，1-已提交
     */
    public void setOddStatus(Integer oddStatus) {
        this.oddStatus = oddStatus;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 是否转扣，0-否，1-是
     */
    public Integer getRedirectFlag() {
        return redirectFlag;
    }

    /**
     * 是否转扣，0-否，1-是
     */
    public void setRedirectFlag(Integer redirectFlag) {
        this.redirectFlag = redirectFlag;
    }

     /**
      * 零星用工申请单实体
      */
     public List<OddInfoVO> getOddInfoVos() {
        return oddInfoVos;
     }

     /**
      * 零星用工申请单实体
      */
     public void setOddInfoVos(List<OddInfoVO> oddInfoVos) {
        this.oddInfoVos = oddInfoVos;
     }
}
