/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sync.bean.Imgprog;
import com.ejianc.business.sync.bean.Imgprogb;
import com.ejianc.business.sync.mapper.ImgprogMapper;
import com.ejianc.business.sync.service.IImgprogService;
import com.ejianc.business.sync.service.IImgprogbService;
import com.ejianc.business.sync.vo.SumGrapDetailVO;
import com.ejianc.business.sync.vo.SumGrapVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="imgprogService")
public class ImgprogService
extends BaseServiceImpl<ImgprogMapper, Imgprog>
implements IImgprogService {
    private Logger logger = LoggerFactory.getLogger(ImgprogService.class);
    @Autowired
    private IImgprogbService imgprogbService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<String> syncImg(SumGrapVO sumGrapVO) {
        Long id = sumGrapVO.getId();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String ts = sdf.format(new Date());
        Imgprog entity = new Imgprog();
        entity.setPkImgprog("ST" + id);
        entity.setCsrcId("ST" + id);
        entity.setvBillCode(sumGrapVO.getBillCode());
        entity.setPkProject(sumGrapVO.getProjectSourceId());
        entity.setPkCorp(sumGrapVO.getCropSourceId());
        entity.setPkContract(sumGrapVO.getContractId());
        entity.setPeriod(sumGrapVO.getSumMonth());
        entity.setReportPerson(this.sessionManager.getUserContext().getUserName());
        entity.setnConfirmMny(sumGrapVO.getSumApproveMny());
        entity.setBisSettle("N");
        entity.setCsrcbId("");
        entity.setTs(ts);
        List detailList = sumGrapVO.getDetailList();
        ArrayList<Imgprogb> list = new ArrayList<Imgprogb>();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (SumGrapDetailVO detai : detailList) {
                if (detai.getLeafFlag() != 0) continue;
                Imgprogb vo = new Imgprogb();
                vo.setPkImgprogb("ST" + detai.getId());
                vo.setCsrcbId("ST" + detai.getId());
                vo.setPkImgprog("ST" + id);
                vo.setCsrcId("ST" + id);
                vo.setPkSublist(detai.getInfoId());
                vo.setNthisfinishnum(detai.getApproveNum());
                vo.setNthisfinishoriginmny(detai.getApproveMny());
                vo.setNprice(detai.getPrice());
                vo.setBisSettle("N");
                vo.setTs(ts);
                list.add(vo);
            }
        }
        entity.setDetailList(list);
        try {
            ((ImgprogMapper)this.baseMapper).insertImgprog(entity);
            if (CollectionUtils.isNotEmpty(list)) {
                for (Imgprogb imgprogb : list) {
                    this.imgprogbService.batchInsert(imgprogb);
                }
            }
            this.logger.info("imgprog\u63d2\u5165\u5b8c\u6bd5:" + JSONObject.toJSONString((Object)entity));
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            return CommonResponse.error((String)"\u5f62\u8c61\u8fdb\u5ea6\u63d2\u5165NC\u5e93\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> delSyncImg(Long id) {
        ((ImgprogMapper)this.baseMapper).delSyncImg("ST" + id);
        ((ImgprogMapper)this.baseMapper).delSyncImgB("ST" + id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public List selectStatus(Integer day) {
        return ((ImgprogMapper)this.baseMapper).selectStatus(day);
    }

    @Override
    public List getSyncImgList() {
        return ((ImgprogMapper)this.baseMapper).getSyncImgList();
    }

    @Override
    public Integer getSyncImg(Long id) {
        return ((ImgprogMapper)this.baseMapper).getSyncImg("ST" + id);
    }
}

