package com.ejianc.business.sync.service;

import com.ejianc.business.sync.bean.BuckleDetail;
import com.ejianc.business.sync.bean.OutContract;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface IBuckleDetailService extends IBaseService<BuckleDetail> {
    @Transactional(propagation= Propagation.NOT_SUPPORTED)
    boolean batchInsert(List<BuckleDetail> buckleDetailList, List<OutContract> outContractList) throws Exception;

    List selectStatus(Integer day);
    @Transactional(propagation= Propagation.NOT_SUPPORTED)
    List select();
    @Transactional(propagation= Propagation.NOT_SUPPORTED)
    Integer getOutContract(String pkOdd);
    @Transactional(propagation= Propagation.NOT_SUPPORTED)
    Integer getBuckleList(String pkOdd);
    @Transactional(propagation= Propagation.NOT_SUPPORTED)
    void delOutContract(String pkOdd);
    @Transactional(propagation= Propagation.NOT_SUPPORTED)
    void delBuckleList(String pkOdd);

    List selectRedirect(Integer day);
}
