/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sync.service.impl;

import com.ejianc.business.sync.bean.BuckleDetail;
import com.ejianc.business.sync.bean.CmSubList;
import com.ejianc.business.sync.bean.OutContract;
import com.ejianc.business.sync.mapper.CmSubListMapper;
import com.ejianc.business.sync.service.IBuckleDetailService;
import com.ejianc.business.sync.service.ICmSubListService;
import com.ejianc.business.sync.vo.OddInfoVO;
import com.ejianc.business.sync.vo.OddRedirectVO;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.business.sync.vo.OddVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CmSubListServiceImpl
extends BaseServiceImpl<CmSubListMapper, CmSubList>
implements ICmSubListService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBuckleDetailService buckleDetailService;

    @Override
    public CommonResponse<String> syncOdd(OddVO oddVO) {
        this.syncSubList(oddVO);
        this.syncCenterOdd(oddVO);
        return CommonResponse.success((String)"nc\u6570\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<OddSyncVo> updateNcFlag(Integer day) {
        OddSyncVo vo = new OddSyncVo();
        List list = this.buckleDetailService.selectStatus(day, "ST-");
        ArrayList<Long> nlist = new ArrayList<Long>();
        ArrayList<Long> ylist = new ArrayList<Long>();
        for (int i = 0; i < list.size(); ++i) {
            if (null == ((Map)list.get(i)).get("PK_BUCKLEDETAIL")) continue;
            String pk = ((Map)list.get(i)).get("PK_BUCKLEDETAIL").toString().replaceAll("ST-", "");
            ((Map)list.get(i)).put("PK_BUCKLEDETAIL", pk);
            if (((Map)list.get(i)).get("BISSETTLE") != null && ((Map)list.get(i)).get("BISSETTLE").equals("Y")) {
                ylist.add(Long.valueOf(pk));
                continue;
            }
            if (((Map)list.get(i)).get("BISSETTLE") == null || !((Map)list.get(i)).get("BISSETTLE").equals("N")) continue;
            nlist.add(Long.valueOf(pk));
        }
        if (ylist != null && ylist.size() > 0) {
            vo.setYinfo(ylist);
        }
        if (nlist != null && nlist.size() > 0) {
            vo.setNinfo(nlist);
        }
        List rlist = this.buckleDetailService.selectRedirect(day, "ST-");
        ArrayList<Long> tlist = new ArrayList<Long>();
        ArrayList<Long> flist = new ArrayList<Long>();
        for (int i = 0; i < rlist.size(); ++i) {
            if (null == ((Map)rlist.get(i)).get("PK_OUTCONTRACT")) continue;
            String pk = ((Map)rlist.get(i)).get("PK_OUTCONTRACT").toString().replaceAll("ST-", "");
            ((Map)rlist.get(i)).put("PK_OUTCONTRACT", pk);
            if (((Map)rlist.get(i)).get("BISSETTLE") != null && ((Map)rlist.get(i)).get("BISSETTLE").equals("Y")) {
                tlist.add(Long.valueOf(pk));
                continue;
            }
            if (((Map)rlist.get(i)).get("BISSETTLE") == null || !((Map)rlist.get(i)).get("BISSETTLE").equals("N")) continue;
            flist.add(Long.valueOf(pk));
        }
        if (tlist != null && tlist.size() > 0) {
            vo.setYredirect(tlist);
        }
        if (flist != null && flist.size() > 0) {
            vo.setNredirect(flist);
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f", (Object)vo);
    }

    @Override
    public CommonResponse<Boolean> syncFlag(Long id) {
        Integer getOutContract = this.buckleDetailService.getOutContract(String.valueOf(id));
        Integer getBuckleList = this.buckleDetailService.getBuckleList(String.valueOf(id));
        if (getOutContract > 0 || getBuckleList > 0) {
            this.logger.debug("\u6570\u636e\u5728NC\u5df2\u7ed3\u7b97\uff0c\u65e0\u6cd5\u5f03\u5ba1");
            return CommonResponse.success((String)"\u6570\u636e\u5728NC\u5df2\u7ed3\u7b97\uff0c\u65e0\u6cd5\u5f03\u5ba1", (Object)true);
        }
        this.logger.debug("\u6570\u636e\u5728NC\u672a\u7ed3\u7b97");
        return CommonResponse.success((String)"\u6570\u636e\u5728NC\u672a\u7ed3\u7b97\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> delSync(Long id) {
        this.buckleDetailService.delOutContract(String.valueOf(id));
        this.buckleDetailService.delBuckleList(String.valueOf(id));
        return CommonResponse.success((String)"\u5220\u9664\u4e2d\u95f4\u8868\u6210\u529f\uff01", (Object)true);
    }

    private void syncSubList(OddVO odd) {
        List manualOddInfoList = odd.getOddInfoEntities();
        if (manualOddInfoList == null || manualOddInfoList.isEmpty()) {
            return;
        }
        ArrayList<CmSubList> toAddLists = new ArrayList<CmSubList>();
        CmSubList sublist = null;
        String pk_contract = odd.getContractId();
        String pk_corp = odd.getCropSourceId();
        for (OddInfoVO info : manualOddInfoList) {
            this.logger.debug("\u53ea\u63d2\u5165\u624b\u52a8\u65b0\u589e\u7684\u6e05\u5355");
            if (info.getSourceType() != 1) continue;
            sublist = new CmSubList();
            sublist.setBiscurrentlist("Y");
            sublist.setPk_measdoc(((CmSubListMapper)this.baseMapper).selectPkMeasdoc("%" + info.getInfoUnit() + "%"));
            sublist.setDr(0);
            sublist.setTs(this.getTs());
            sublist.setPk_contract(pk_contract);
            sublist.setPk_sublist(this.generateNCPK(pk_corp));
            sublist.setPk_wbsdef(((CmSubListMapper)this.baseMapper).selectPkWbs(pk_contract));
            sublist.setIlistsource(2);
            sublist.setVlistcode(info.getCode());
            sublist.setVlistname(info.getName());
            sublist.setVmemo("\u8f7b\u91cf\u5316\u5e73\u53f0\u63a8\u9001");
            sublist.setNnum(info.getReviewNum());
            sublist.setNprice(info.getReviewPrice());
            sublist.setNfinishsumnum(info.getReviewNum());
            sublist.setNfinishsumoriginmny(info.getReviewPrice());
            sublist.setNtotaloriginmny(info.getReviewMny());
            sublist.setIattribute(0);
            sublist.setVreserve9(String.valueOf(odd.getId()));
            toAddLists.add(sublist);
        }
        if (toAddLists != null && toAddLists.size() > 0) {
            super.saveBatch(toAddLists);
            ((CmSubListMapper)this.baseMapper).updateContractTs(pk_contract, this.getTs());
        }
    }

    private String generateNCPK(String pk_corp) {
        String uid = UUID.randomUUID().toString();
        uid = uid.replace("-", "");
        uid = uid.substring(0, 16);
        if (pk_corp == null) {
            pk_corp = "0001";
        }
        return pk_corp + uid;
    }

    private String getTs() {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);
    }

    private boolean syncCenterOdd(OddVO odd) {
        List oddInfoList = odd.getOddInfoEntities();
        try {
            ArrayList<BuckleDetail> buckleDetailList = new ArrayList<BuckleDetail>();
            for (int i = 0; i < oddInfoList.size(); ++i) {
                OddInfoVO oddInfo = (OddInfoVO)oddInfoList.get(i);
                BuckleDetail buckleDetail = new BuckleDetail();
                buckleDetail.setPkBuckleDetail("ST-" + String.valueOf(oddInfo.getId()));
                buckleDetail.setPkCorp(odd.getCropSourceId());
                buckleDetail.setPkProject(odd.getProjectSourceId());
                buckleDetail.setCsrcbId(String.valueOf("ST-" + oddInfo.getId()));
                buckleDetail.setDDeductDate("");
                buckleDetail.setBisSettle("N");
                buckleDetail.setCsrcId(String.valueOf("ST-" + odd.getId()));
                buckleDetail.setNsettlecount(oddInfo.getReviewNum());
                buckleDetail.setNsettleprice(oddInfo.getReviewPrice());
                buckleDetail.setNsettlesum(oddInfo.getReviewMny());
                buckleDetail.setPkContractA(odd.getContractId());
                buckleDetail.setVSettleCostItem(oddInfo.getName());
                buckleDetail.setReporter(odd.getCreateName());
                buckleDetail.setDmakedate(new SimpleDateFormat("yyyy-MM-dd").format(odd.getCreateDate()));
                buckleDetailList.add(buckleDetail);
            }
            this.logger.debug("buckleDetailList:" + buckleDetailList);
            ArrayList<OutContract> outContractList = new ArrayList<OutContract>();
            for (int i = 0; i < oddInfoList.size(); ++i) {
                OddInfoVO oddInfo = (OddInfoVO)oddInfoList.get(i);
                if (oddInfo.getOddRedirectEntities() == null || oddInfo.getOddRedirectEntities().size() <= 0) continue;
                for (int j = 0; j < oddInfo.getOddRedirectEntities().size(); ++j) {
                    OutContract outContract = new OutContract();
                    OddRedirectVO oddRedirect = (OddRedirectVO)oddInfo.getOddRedirectEntities().get(j);
                    outContract.setPkOutContract("ST-" + String.valueOf(oddRedirect.getId()));
                    outContract.setPkContract(oddRedirect.getContractId());
                    outContract.setNDeductOriginMny(oddRedirect.getMny());
                    outContract.setPkCorp(odd.getCropSourceId());
                    outContract.setPkProject(odd.getProjectSourceId());
                    outContract.setCsrcbId(String.valueOf("ST-" + oddInfo.getId()));
                    outContract.setDDeductDate("");
                    outContract.setBisSettle("N");
                    outContract.setCsrcId(String.valueOf("ST-" + odd.getId()));
                    outContract.setReporter(odd.getCreateName());
                    outContract.setDmakedate(new SimpleDateFormat("yyyy-MM-dd").format(odd.getCreateDate()));
                    outContract.setDr(0);
                    outContractList.add(outContract);
                }
            }
            this.logger.debug("\u540c\u6b65\u5f00\u59cb");
            this.buckleDetailService.batchInsert(buckleDetailList, outContractList);
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            throw new BusinessException("\u96f6\u661f\u7528\u5de5\u63d2\u5165NC\u5e93\u5931\u8d25");
        }
        return true;
    }
}

