package com.ejianc.business.sync.controller.api;

import com.ejianc.business.sync.service.IImgprogService;
import com.ejianc.business.sync.vo.SumGrapVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

@RestController
@RequestMapping("/api/grapsync")
public class GrapSyncController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IImgprogService imgprogService;

    /**
     * 进度计量同步至nc中间表
     * @param sumGrapVO
     * @return
     */
    @RequestMapping(value = "/syncImg", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncImg(@RequestBody SumGrapVO sumGrapVO) {
        return imgprogService.syncImg(sumGrapVO);
    }

    /**
     * 删除NC中间表
     * @param id
     * @return
     */
    @RequestMapping(value = "/delSyncImg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delSyncImg(@RequestParam("id") Long id) {
        return imgprogService.delSyncImg(id);
    }

    /**
     * 查看数据有没有被同步
     * @param id
     * @return
     */
    @RequestMapping(value = "/getSyncImg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> getSyncImg(@RequestParam("id") Long id) {
        return CommonResponse.success("查询成功！", imgprogService.getSyncImg(id));
    }

    /**
     * 查询所有形象进度
     * @param
     * @return
     */
    @RequestMapping(value = "/getSyncImgList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List> getSyncImgList() {
        return CommonResponse.success("查询列表数据成功！", imgprogService.getSyncImgList());
    }

    /**
     * 查询进度计量对应NC结算状态
     * @param day
     * @return
     */
    @RequestMapping(value = "/selectStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List> selectStatus(Integer day) {
//        day = 2; // NC没有维护ts 先按照入的ts取最近2个月的数据更新
        return CommonResponse.success("查询列表数据成功！", imgprogService.selectStatus(day));
    }
}
