package com.ejianc.business.tender.controller;

import java.io.Serializable;

import com.ejianc.business.tender.vo.ReportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tender.bean.TenderEntity;
import com.ejianc.business.tender.service.ITenderService;
import com.ejianc.business.tender.vo.TenderVO;

/**
 * 工程业绩实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("tender")
public class TenderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITenderService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TenderVO> saveOrUpdate(@RequestBody TenderVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TenderVO> queryDetail(Long id) {
    	TenderEntity entity = service.selectById(id);
    	TenderVO vo = BeanMapper.map(entity, TenderVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TenderVO> vos) {
        service.removeByIds(vos.stream().map(TenderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TenderVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<TenderEntity> page = service.queryPage(param,false);
        IPage<TenderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TenderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TenderEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Tender-export.xlsx", beans, response);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/getSumIndex", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReportVO> getSumIndex(@RequestBody QueryParam param) {
        ReportVO reportVO = new ReportVO();
        List<TenderEntity> tenderEntityList = service.queryList(param);
        BigDecimal sumContractMny = tenderEntityList.stream().map(TenderEntity::getContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumBuildHeight = tenderEntityList.stream().map(TenderEntity::getBuildHeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumRoadLength = tenderEntityList.stream().map(TenderEntity::getRoadLength).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumAssembArea = tenderEntityList.stream().map(TenderEntity::getAssembArea).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumAssembContractMny = tenderEntityList.stream().map(TenderEntity::getAssembContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPcNum = tenderEntityList.stream().map(TenderEntity::getPcNum).reduce(BigDecimal.ZERO, BigDecimal::add);

        reportVO.setProjectNum(tenderEntityList.size());
        reportVO.setSumContractMny(sumContractMny);
        reportVO.setSumContractMny(sumBuildHeight);
        reportVO.setSumContractMny(sumRoadLength);
        reportVO.setSumContractMny(sumAssembArea);
        reportVO.setSumContractMny(sumAssembContractMny);
        reportVO.setSumContractMny(sumPcNum);

        return CommonResponse.success("查询成功！", reportVO);
    }

    /**
     * @Description getDeleteList
     * @param param
     */
    @RequestMapping(value = "/queryDeleteList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TenderVO>> queryDeleteList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<TenderEntity> page = service.queryPage(param,false);
        IPage<TenderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TenderVO.class));
        return CommonResponse.success("查询详情数据成功！", pageData);
    }

    /**
     * @Description recoveryDeleteList
     * @param vos
     */
    @RequestMapping(value = "/recoveryDeleteList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> recoveryDeleteList(@RequestBody List<TenderVO> vos) {
        boolean flag = service.recoveryDeleteList(vos);
        return CommonResponse.success("恢复删除工程业绩成功！", flag);
    }


}
