package com.ejianc.business.wzxt.api;

import com.ejianc.business.wzxt.hystrix.ZjwjWzxtSyncHystrix;
import com.ejianc.business.wzxt.vo.SyncControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanVO;
import com.ejianc.business.wzxt.vo.sync.SyncCtPlanDetailVO;
import com.ejianc.business.wzxt.vo.sync.SyncCtPlanVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;

/**
 * 同步数据的rpc服务
 *
 * @author liyongjia
 *
 */
@FeignClient(name= "cscec5b-xell-web", url="${common.env.base-host}", path="cscec5b-xell-web", fallback = ZjwjWzxtSyncHystrix.class)
public interface IZjwjWzxtSyncApi {


	/**
	 * 获取同步总控计划主表时间
	 */
	@GetMapping(value = "api/zjwjsync/queryLastTtplanSyncTime")
	CommonResponse<Date> queryLastTtplanSyncTime(@RequestParam(required = false) String params);

	/**
	 * 总控计划表头
	 *
	 * @param controlPlanVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanList")
	CommonResponse<String> syncControlPlanList(@RequestBody  List<SyncControlPlanVO> controlPlanVOS);


	/**
	 * 获取同步总控计划表体时间
	 */
	@GetMapping(value = "api/zjwjsync/queryLastTtplanDetailSyncTime")
	CommonResponse<Date> queryLastTtplanDetailSyncTime(@RequestParam(required = false) String params);

	/**
	 * 总控计划表体
	 *
	 * @param controlPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanDetailList")
	CommonResponse<String> syncControlPlanDetailList(@RequestBody List<SyncControlPlanDetailVO> controlPlanDetailVOS);


	/**
	 * 获取同步消耗材总控计划主表时间
	 */
	@GetMapping(value = "api/zjwjsync/queryLastCtplanSyncTime")
	CommonResponse<Date> queryLastCtplanSyncTime(@RequestParam(required = false) String params);

	/**
	 * 消耗材总控计划表头
	 *
	 * @param ctPlanVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncCtPlanList")
	CommonResponse<String> syncCtPlanList(@RequestBody  List<SyncCtPlanVO> ctPlanVOS);

	/**
	 * 获取同步消耗材总控计划主表时间
	 */
	@GetMapping(value = "api/zjwjsync/queryLastCtplanDetailSyncTime")
	CommonResponse<Date> queryLastCtplanDetailSyncTime(@RequestParam(required = false) String params);

	/**
	 * 消耗材总控计划表体
	 *
	 * @param ctPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncCtPlanDetailList")
	CommonResponse<String> syncCtPlanDetailList(@RequestBody List<SyncCtPlanDetailVO> ctPlanDetailVOS);

	/**
	 * 同步MRO项目
	 *
	 * @return
	 */
	@GetMapping(value = "api/zjwjsync/syncMroProjectList")
	CommonResponse<String> syncMroProjectList();

	/**
	 * 同步MRO送货单
	 *
	 * @return
	 */
	@GetMapping(value = "api/zjwjsync/syncMroDeliveryList")
	CommonResponse<String> syncMroDeliveryList();

}
