package com.ejianc.business.wzxt.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 节超原因分析
 * 
 * @author generator
 * 
 */
public class CauseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectSourceId; // 项目来源ID
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgSourceId; // 组织来源ID
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织
    private String parentOrgSourceId; // 上级组织来源ID
    private Long dutyPersonId; // 责任人ID
    private String dutyPersonName; // 责任人
    private String dutySection; // 责任工区
    private String employeeId; // 经办人ID
    private String employeeName; // 经办人
    private String construction; // 部位名称
    private String exceedCause; // 节超原因分析
    private String improvementMeasure; // 改进措施
    private Integer billState; // 单据状态（审批必须字段）
    private String  billStateName;//
    private List<CauseDetailVO> detailList = new ArrayList<>();

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getDutyPersonId() {
        return dutyPersonId;
    }

    @ReferDeserialTransfer
    public void setDutyPersonId(Long dutyPersonId) {
        this.dutyPersonId = dutyPersonId;
    }
    public String getDutyPersonName() {
        return dutyPersonName;
    }

    public void setDutyPersonName(String dutyPersonName) {
        this.dutyPersonName = dutyPersonName;
    }
    public String getDutySection() {
        return dutySection;
    }

    public void setDutySection(String dutySection) {
        this.dutySection = dutySection;
    }

    public String getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public String getExceedCause() {
        return exceedCause;
    }

    public void setExceedCause(String exceedCause) {
        this.exceedCause = exceedCause;
    }
    public String getImprovementMeasure() {
        return improvementMeasure;
    }

    public void setImprovementMeasure(String improvementMeasure) {
        this.improvementMeasure = improvementMeasure;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<CauseDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CauseDetailVO> detailList) {
        this.detailList = detailList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
