/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.service.IWeighService;
import com.ejianc.business.wzxt.vo.OrderProjectVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.business.wzxt.vo.WeighVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchaseOrder"})
public class OrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IOrderService service;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IWeighService weighService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/queryLinkDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryLinkDetail(Long projectId) {
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(OrderEntity::getProjectId, (Object)projectId);
        lambda.eq(OrderEntity::getEmployeeId, (Object)InvocationInfoProxy.getEmployeeId());
        lambda.orderByDesc(BaseEntity::getCreateTime);
        details = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map(details.get(0), OrderVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/queryOrgSource"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderProjectVO> queryLinkDetail2(Long orgId) {
        CommonResponse parentOrgVo;
        OrderProjectVO res = new OrderProjectVO();
        CommonResponse orgVo = this.orgApi.getOneById(orgId);
        if (!orgVo.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            res.setOrgId(orgId);
            res.setOrgSourceId(((OrgVO)orgVo.getData()).getSourceId());
            res.setParentOrgId(((OrgVO)orgVo.getData()).getParentId());
            CommonResponse<WeighVO> weihgvo = this.weighService.getWeighByProjectDepartmentId(orgId);
            if (weihgvo.isSuccess() && null != weihgvo.getData()) {
                res.setSmartStatus(((WeighVO)weihgvo.getData()).getWeighFlag());
                res.setPlatformCode(((WeighVO)weihgvo.getData()).getScsStationCode());
                res.setPlatformType(((WeighVO)weihgvo.getData()).getScsTypeId());
            } else {
                res.setSmartStatus("0");
                res.setPlatformCode(null);
                res.setPlatformType(null);
            }
        }
        if (!(parentOrgVo = this.orgApi.getOneById(((OrgVO)orgVo.getData()).getParentId())).isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != parentOrgVo.getData()) {
            res.setParentOrgSourceId(((OrgVO)parentOrgVo.getData()).getSourceId());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        this.service.delete(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean createFlag = param.getParams().containsKey("isMyCreate");
        if (createFlag) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            param.getParams().remove("isMyCreate");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if (!mobile) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(vo -> {
                if (null != vo.getReceiveState() && 0 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5f85\u786e\u8ba4");
                } else if (null != vo.getReceiveState() && 1 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5168\u90e8\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 2 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u90e8\u5206\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 3 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5df2\u62d2\u7edd");
                }
                if (null != vo.getDeliverState() && 0 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5f85\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 1 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 2 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                } else if (null != vo.getDeliverState() && 3 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u9000\u56de");
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateReceived"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> updateReceived(@RequestBody OrderVO saveorUpdateVO) {
        return this.service.updateReceived(saveorUpdateVO);
    }

    @RequestMapping(value={"/isMatRefCont"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> isMatRefCont(@RequestBody OrderVO saveorUpdateVO) {
        String matPkList;
        String pkContract = saveorUpdateVO.getDef1();
        if (this.service.isMatRefCont(pkContract, matPkList = saveorUpdateVO.getDef2()).booleanValue()) {
            return CommonResponse.success((Object)true);
        }
        return CommonResponse.error((String)"\u65e0\u6cd5\u5339\u914d\u5408\u540c\u548c\u6750\u6599\u660e\u7ec6\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean createFlag = param.getParams().containsKey("isMyCreate");
        if (createFlag) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            param.getParams().remove("isMyCreate");
        }
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        List listExport = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (null != vo.getReceiveState() && 0 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5f85\u786e\u8ba4");
                } else if (null != vo.getReceiveState() && 1 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5168\u90e8\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 2 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u90e8\u5206\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 3 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5df2\u62d2\u7edd");
                }
                if (null != vo.getDeliverState() && 0 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5f85\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 1 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 2 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                } else if (null != vo.getDeliverState() && 3 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u9000\u56de");
                }
                if (vo.getSubOrderType() == 0) {
                    vo.setOrderTypeName("\u6405\u62cc\u7ad9\u8ba2\u5355");
                } else {
                    vo.setOrderTypeName("\u4f9b\u5e94\u5546\u8ba2\u5355");
                }
            });
            listExport = pageData.getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("orderExport.xlsx", beans, response);
    }
}

