/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.bean.ReviewChangeEntity;
import com.ejianc.business.wzxt.bean.ReviewChangeHisEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailChangeEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailChangeHisEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailEntity;
import com.ejianc.business.wzxt.bean.ReviewEntity;
import com.ejianc.business.wzxt.enums.ChangeTypeEnum;
import com.ejianc.business.wzxt.service.IReviewChangeHisService;
import com.ejianc.business.wzxt.service.IReviewChangeService;
import com.ejianc.business.wzxt.service.IReviewDetailService;
import com.ejianc.business.wzxt.service.IReviewService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reviewChange")
public class ReviewChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IReviewService reviewService;
    @Autowired
    private IReviewDetailService reviewDetailService;
    @Autowired
    private IReviewChangeService reviewChangeService;
    @Autowired
    private IReviewChangeHisService reviewChangeHisService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7528\u91cf\u590d\u6838\u53d8\u66f4\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03--billId:{}, state: {}", (Object)billId, (Object)state);
        ReviewChangeEntity reviewChangeEntity = (ReviewChangeEntity)((Object)this.reviewChangeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        reviewChangeEntity.setCommitDate(new Date());
        reviewChangeEntity.setCommitUserCode(userContext.getUserCode());
        reviewChangeEntity.setCommitUserName(userContext.getUserName());
        this.reviewChangeService.saveOrUpdate((Object)reviewChangeEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7528\u91cf\u590d\u6838\u53d8\u66f4\u64a4\u56de\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        ReviewChangeEntity reviewChangeEntity = (ReviewChangeEntity)((Object)this.reviewChangeService.selectById(billId));
        reviewChangeEntity.setCommitUserName(null);
        reviewChangeEntity.setCommitUserCode(null);
        reviewChangeEntity.setCommitDate(null);
        this.reviewChangeService.saveOrUpdate((Object)reviewChangeEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        ReviewChangeEntity reviewChangeEntity = (ReviewChangeEntity)((Object)this.reviewChangeService.selectById(billId));
        ReviewEntity newPlanEntity = null;
        ReviewEntity oldReview = (ReviewEntity)((Object)this.reviewService.selectById(reviewChangeEntity.getSourceReviewId()));
        CommonResponse stringCommonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "EJCBT202210000045", "reviewFile", String.valueOf(oldReview.getId()), "EJCBT202210000040", "reviewFile");
        if (!stringCommonResponse.isSuccess()) {
            this.logger.info("\u590d\u6838\u53d8\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        } else {
            this.logger.info("\u590d\u6838\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        if (state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            UserContext userContext = this.sessionManager.getUserContext();
            reviewChangeEntity.setCommitDate(new Date());
            reviewChangeEntity.setCommitUserCode(userContext.getUserCode());
            reviewChangeEntity.setCommitUserName(userContext.getUserName());
        }
        reviewChangeEntity.setEffectiveDate(new Date());
        reviewChangeEntity.setEffectiveDate(new Date());
        ReviewChangeHisEntity recordEntity = (ReviewChangeHisEntity)((Object)BeanMapper.map((Object)((Object)oldReview), ReviewChangeHisEntity.class));
        this.logger.info("\u590d\u6838\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03, \u590d\u6838\u53d8\u66f4\u4fe1\u606f\uff1a\u3010{}\u3011, \u53d8\u66f4\u524d\u590d\u6838\u4fe1\u606f: \u3010{}\u3011", (Object)JSON.toJSONString((Object)((Object)reviewChangeEntity)), (Object)JSON.toJSONString((Object)((Object)oldReview)));
        recordEntity.setSourceReviewId(oldReview.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getReviewDetailList())) {
            List<ReviewDetailChangeHisEntity> reviewDetailList = recordEntity.getReviewDetailList();
            Map<Long, List<ReviewDetailChangeHisEntity>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailChangeHisEntity::getParentId));
            ArrayList<ReviewDetailChangeHisEntity> hisEntityList = new ArrayList<ReviewDetailChangeHisEntity>();
            for (ReviewDetailChangeHisEntity reviewDetailChangeHisEntity : reviewDetailList) {
                if (reviewDetailChangeHisEntity.getParentId() != null) continue;
                List<ReviewDetailChangeHisEntity> childList = childMap.get(reviewDetailChangeHisEntity.getId());
                reviewDetailChangeHisEntity.setId(IdWorker.getId());
                childList.forEach(p -> p.setParentId(reviewDetailChangeHisEntity.getId()));
                childList.forEach(p -> p.setId(IdWorker.getId()));
                hisEntityList.add(reviewDetailChangeHisEntity);
                hisEntityList.addAll(childList);
            }
            recordEntity.setReviewDetailList(hisEntityList);
        }
        recordEntity.setCreateUserCode(reviewChangeEntity.getCreateUserCode());
        recordEntity.setCreateTime(reviewChangeEntity.getCreateTime());
        recordEntity.setCreateUserName(reviewChangeEntity.getCreateUserName());
        recordEntity.setModifyUserName(reviewChangeEntity.getModifyUserName());
        recordEntity.setUpdateTime(reviewChangeEntity.getUpdateTime());
        recordEntity.setUpdateUserCode(reviewChangeEntity.getUpdateUserCode());
        recordEntity.setCommitDate(reviewChangeEntity.getCommitDate());
        recordEntity.setCommitUserCode(reviewChangeEntity.getCommitUserCode());
        recordEntity.setCommitUserName(reviewChangeEntity.getCommitUserName());
        recordEntity.setEffectiveDate(reviewChangeEntity.getEffectiveDate());
        recordEntity.setChangeReviewId(reviewChangeEntity.getId());
        recordEntity.setChangeUserName(reviewChangeEntity.getChangeUserName());
        recordEntity.setChangeReason(reviewChangeEntity.getChangeReason());
        this.reviewChangeHisService.saveOrUpdate((Object)recordEntity, false);
        this.reviewChangeService.saveOrUpdate((Object)reviewChangeEntity, false);
        newPlanEntity = (ReviewEntity)((Object)BeanMapper.map((Object)((Object)oldReview), ReviewEntity.class));
        newPlanEntity.setChangeState(2);
        newPlanEntity.setCurChangingReviewId(null);
        newPlanEntity.setChangeVersion(reviewChangeEntity.getChangeVersion());
        List<ReviewDetailChangeEntity> reviewChangeDetailList = reviewChangeEntity.getReviewDetailList();
        Map changeEntityMap = reviewChangeDetailList.stream().filter(s -> s.getChangeType().equals(ChangeTypeEnum.\u53d8\u66f4\u9879.getCode())).collect(Collectors.toMap(ReviewDetailChangeEntity::getTargetId, Function.identity()));
        Map<Long, List<ReviewDetailChangeEntity>> newChangeEntityMap = reviewChangeDetailList.stream().filter(s -> s.getChangeType().equals(ChangeTypeEnum.\u589e\u8865\u9879.getCode()) && s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailChangeEntity::getParentId));
        List reviewDetailChangeParentList = reviewChangeDetailList.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());
        Map changeEntityAllMap = reviewChangeDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        List<ReviewDetailEntity> oldReviewDetailList = oldReview.getReviewDetailList();
        ArrayList<ReviewDetailEntity> newReviewDetailList = new ArrayList<ReviewDetailEntity>();
        for (ReviewDetailEntity reviewDetailEntity : oldReviewDetailList) {
            if (!changeEntityMap.containsKey(reviewDetailEntity.getId())) continue;
            ReviewDetailChangeEntity reviewDetailChangeEntity = (ReviewDetailChangeEntity)((Object)changeEntityMap.get(reviewDetailEntity.getId()));
            if (reviewDetailEntity.getParentId() == null) {
                reviewDetailEntity.setPlanNum(reviewDetailChangeEntity.getPlanNum());
                reviewDetailEntity.setReviewNum(reviewDetailChangeEntity.getReviewNum());
                reviewDetailEntity.setRationRate(reviewDetailChangeEntity.getRationRate());
                reviewDetailEntity.setRationNum(reviewDetailChangeEntity.getRationNum());
                reviewDetailEntity.setTargetNum(reviewDetailChangeEntity.getTargetNum());
                reviewDetailEntity.setTargetRate(reviewDetailChangeEntity.getTargetRate());
                newReviewDetailList.add(reviewDetailEntity);
            }
            if (reviewDetailEntity.getParentId() == null) continue;
            reviewDetailEntity.setPlanNum(reviewDetailChangeEntity.getPlanNum());
            reviewDetailEntity.setReviewNum(reviewDetailChangeEntity.getReviewNum());
            newReviewDetailList.add(reviewDetailEntity);
        }
        if (CollectionUtils.isNotEmpty(reviewDetailChangeParentList)) {
            for (ReviewDetailChangeEntity reviewDetailChangeEntity : reviewDetailChangeParentList) {
                ReviewDetailEntity detailEntity;
                if (!newChangeEntityMap.containsKey(reviewDetailChangeEntity.getId())) continue;
                List<ReviewDetailChangeEntity> reviewDetailChangeEntities = newChangeEntityMap.get(reviewDetailChangeEntity.getId());
                if (reviewDetailChangeEntity.getChangeType().equals(ChangeTypeEnum.\u53d8\u66f4\u9879.getCode())) {
                    for (ReviewDetailChangeEntity reviewDetailChangeChildEntity : reviewDetailChangeEntities) {
                        reviewDetailChangeChildEntity.setParentId(reviewDetailChangeEntity.getTargetId());
                        reviewDetailChangeChildEntity.setId(IdWorker.getId());
                        detailEntity = (ReviewDetailEntity)((Object)BeanMapper.map((Object)((Object)reviewDetailChangeChildEntity), ReviewDetailEntity.class));
                        newReviewDetailList.add(detailEntity);
                    }
                }
                if (!reviewDetailChangeEntity.getChangeType().equals(ChangeTypeEnum.\u589e\u8865\u9879.getCode())) continue;
                reviewDetailChangeEntity.setId(IdWorker.getId());
                for (ReviewDetailChangeEntity reviewDetailChangeChildEntity : reviewDetailChangeEntities) {
                    reviewDetailChangeChildEntity.setParentId(reviewDetailChangeEntity.getId());
                    reviewDetailChangeChildEntity.setId(IdWorker.getId());
                    detailEntity = (ReviewDetailEntity)((Object)BeanMapper.map((Object)((Object)reviewDetailChangeChildEntity), ReviewDetailEntity.class));
                    newReviewDetailList.add(detailEntity);
                }
                ReviewDetailEntity reviewDetailEntity = (ReviewDetailEntity)((Object)BeanMapper.map((Object)((Object)reviewDetailChangeEntity), ReviewDetailEntity.class));
                newReviewDetailList.add(reviewDetailEntity);
            }
        }
        this.reviewService.saveOrUpdate((Object)newPlanEntity);
        this.reviewDetailService.saveOrUpdateBatch(newReviewDetailList);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

