/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class MroSignUtils {
    private static final String CHARSET_UTF8 = "utf-8";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String APPID = "xxx";
    private static final String APPSECRET = "xxx";
    private static final String SERVERURL = "http://api.jc.yzw.cn.qa:8001/open.api";

    public static String encrypt(String signature) throws RuntimeException {
        return MroSignUtils.encrypt(signature, "", false);
    }

    public static String encrypt(String signature, String encode) throws RuntimeException {
        return MroSignUtils.encrypt(signature, encode, false);
    }

    public static String encrypt(String signature, String encode, boolean isUpperCase) throws RuntimeException {
        byte[] plainText;
        MessageDigest md5;
        if (signature == null) {
            return null;
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException var8) {
            throw new RuntimeException("\u52a0\u5bc6\u7b97\u6cd5\u9519\u8bef", var8);
        }
        try {
            plainText = StringUtils.isBlank((CharSequence)encode) ? signature.getBytes() : signature.getBytes(encode);
        }
        catch (UnsupportedEncodingException var7) {
            throw new RuntimeException("MD5\u52a0\u5bc6\u5f02\u5e38", var7);
        }
        md5.update(plainText);
        String ret = MroSignUtils.hexDump(md5.digest(), isUpperCase);
        return ret;
    }

    private static String hexDump(byte[] bArray, boolean isUpperCase) {
        StringBuilder sb = new StringBuilder(bArray.length);
        for (byte b : bArray) {
            String sTemp = Integer.toHexString(0xFF & b);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            if (isUpperCase) {
                sb.append(sTemp.toUpperCase());
                continue;
            }
            sb.append(sTemp);
        }
        return sb.toString();
    }

    public static String signRequest(Map<String, String> headers, String secret) throws IOException {
        Object[] keys = headers.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            String value = headers.get(key);
            if (!MroSignUtils.isNotEmpty((String)key) || !MroSignUtils.isNotEmpty(value)) continue;
            query.append("&").append((String)key).append("=").append(value);
        }
        query.append("&appsecret=").append(secret);
        String data = query.toString().substring(1).toLowerCase();
        byte[] bytes = MroSignUtils.encryptMD5(data);
        return MroSignUtils.byte2hex(bytes);
    }

    private static byte[] encryptMD5(String data) throws IOException {
        return MroSignUtils.encryptMD5(data.getBytes(CHARSET_UTF8));
    }

    private static byte[] encryptMD5(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static byte[] encryptHMAC(String data, String secret) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(CHARSET_UTF8), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes(CHARSET_UTF8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toLowerCase());
        }
        return sign.toString();
    }

    private static boolean isNotEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String callApi(URL url, Map<String, String> params) throws IOException {
        String query = MroSignUtils.buildQuery(params, CHARSET_UTF8);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(CHARSET_UTF8);
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Host", url.getHost());
            conn.setRequestProperty("Accept", "text/xml,text/javascript");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            out = conn.getOutputStream();
            out.write(content);
            rsp = MroSignUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!MroSignUtils.isNotEmpty(name) || !MroSignUtils.isNotEmpty(value)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    private static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = MroSignUtils.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                return MroSignUtils.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return MroSignUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = CHARSET_UTF8;
        if (MroSignUtils.isNotEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || !MroSignUtils.isNotEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }
}

