/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.CauseDetailEntity;
import com.ejianc.business.wzxt.bean.CauseEntity;
import com.ejianc.business.wzxt.mapper.CauseMapper;
import com.ejianc.business.wzxt.service.ICauseService;
import com.ejianc.business.wzxt.vo.CauseVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="causeService")
public class CauseServiceImpl
extends BaseServiceImpl<CauseMapper, CauseEntity>
implements ICauseService {
    @Autowired
    private IOrgApi orgApi;
    private static final String WJ_WZXT_CAUSE = "CAUSE_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi iProjectApi;

    @Override
    public CauseVO saveOrUpdate(CauseVO saveOrUpdateVO) {
        CauseEntity entity = (CauseEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CauseEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WJ_WZXT_CAUSE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (CauseDetailEntity causeDetailEntity : entity.getDetailList()) {
            if (!StringUtils.isNotEmpty((CharSequence)causeDetailEntity.getConstructionDetail())) continue;
            stringBuffer.append(causeDetailEntity.getConstructionDetail()).append(",");
        }
        if (stringBuffer != null) {
            entity.setConstruction(stringBuffer.substring(0, stringBuffer.length() - 1));
        }
        ArrayList<Long> projectId = new ArrayList<Long>();
        projectId.add(entity.getProjectId());
        CommonResponse projectRegisterVO = this.iProjectApi.queryProjectByIds(projectId);
        if (projectRegisterVO.getCode() == 0 && projectRegisterVO.getData() != null) {
            ProjectRegisterVO registerVO = (ProjectRegisterVO)((List)projectRegisterVO.getData()).get(0);
            entity.setOrgId(registerVO.getProjectDepartmentId());
            CommonResponse orgVo = this.orgApi.detailById(entity.getOrgId());
            entity.setOrgName(((OrgVO)orgVo.getData()).getName());
            if (((OrgVO)orgVo.getData()).getParentId() != null) {
                entity.setParentOrgId(((OrgVO)orgVo.getData()).getParentId());
            } else {
                entity.setParentOrgId(entity.getOrgId());
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u9879\u76ee\u90e8\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        this.saveOrUpdate((Object)entity, false);
        CauseVO vo = (CauseVO)BeanMapper.map((Object)((Object)entity), CauseVO.class);
        return vo;
    }
}

