/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="check")
public class CheckBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if (entity.getSaveState() == 0) {
            entity.setSaveState(1);
            this.checkService.saveOrUpdate((Object)entity, false);
            this.logger.info("\u5355\u636e----" + billId + "----\u5df2\u4fdd\u5b58");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.checkService.push2Supplier(billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if (entity.getUseState() == 1) {
            this.logger.info("\u5355\u636e----" + billId + "----\u5df2\u63a8\u9001NC");
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u63a8\u9001NC\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        if (null != entity.getMroState() && entity.getMroState() == 1) {
            this.logger.info("\u5355\u636e----" + billId + "----\u5df2\u63a8\u9001MRO");
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u63a8\u9001MRO\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            this.checkService.rollBackForSupplier(billId);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

