/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.bean.ReviewChangeHisEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailEntity;
import com.ejianc.business.wzxt.bean.ReviewEntity;
import com.ejianc.business.wzxt.enums.ChangeTypeEnum;
import com.ejianc.business.wzxt.mapper.ReviewMapper;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.service.IReviewChangeHisService;
import com.ejianc.business.wzxt.service.IReviewDetailService;
import com.ejianc.business.wzxt.service.IReviewService;
import com.ejianc.business.wzxt.vo.ReviewChangeHisVO;
import com.ejianc.business.wzxt.vo.ReviewDetailVO;
import com.ejianc.business.wzxt.vo.ReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reviewService")
public class ReviewServiceImpl
extends BaseServiceImpl<ReviewMapper, ReviewEntity>
implements IReviewService {
    private static final String BILL_CODE = "xell-review-code";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ReviewMapper reviewMapper;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IReviewDetailService reviewDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IReviewChangeHisService reviewChangeHisService;

    @Override
    public ReviewVO saveOrUpdate(ReviewVO saveOrUpdateVO) {
        CommonResponse orgParentVo = this.orgApi.getOneById(saveOrUpdateVO.getParentOrgId());
        if (!orgParentVo.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u8be6\u60c5\u5931\u8d25");
        }
        saveOrUpdateVO.setParentOrgSourceId(((OrgVO)orgParentVo.getData()).getSourceId());
        ReviewEntity entity = (ReviewEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReviewEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        UserContext userContext = this.sessionManager.getUserContext();
        ReviewEntity saveEntity = null;
        if (null == saveOrUpdateVO.getId()) {
            saveEntity = (ReviewEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReviewEntity.class));
            saveEntity.setId(IdWorker.getId());
            saveEntity.setChangeState(0);
            saveEntity.setChangeVersion(1);
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (ReviewEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReviewEntity.class));
        }
        List<ReviewDetailEntity> reviewDetailList = entity.getReviewDetailList();
        saveEntity.setReviewDetailList(reviewDetailList);
        super.saveOrUpdate((Object)saveEntity, false);
        ReviewVO vo = (ReviewVO)BeanMapper.map((Object)((Object)saveEntity), ReviewVO.class);
        List reviewDetailListss = vo.getReviewDetailList();
        Map<Long, List<ReviewDetailVO>> childMap = reviewDetailListss.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailVO::getParentId));
        List reviewDetailVOS = reviewDetailListss.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());
        for (ReviewDetailVO reviewDetailVO : reviewDetailVOS) {
            List<ReviewDetailVO> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        vo.setReviewDetailList(reviewDetailVOS);
        return vo;
    }

    @Override
    public CommonResponse<List<ReviewDetailVO>> getReviewInfo(Long projectId, Long billId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        ReviewEntity reviewEntity = (ReviewEntity)((Object)this.reviewMapper.selectOne((Wrapper)query));
        if (!(null == reviewEntity || null != billId && reviewEntity.getId().equals(billId))) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u7528\u6599\u590d\u6838\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper lambdaPlan = Wrappers.lambdaQuery();
        lambdaPlan.eq(PlanEntity::getProjectId, (Object)projectId);
        lambdaPlan.in(PlanEntity::getBillState, list);
        List planEntityList = this.planService.list((Wrapper)lambdaPlan);
        if (CollectionUtils.isEmpty((Collection)planEntityList)) {
            throw new BusinessException("\u6ca1\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u8ba1\u5212\uff01");
        }
        List planIds = planEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaPlanDetail = Wrappers.lambdaQuery();
        lambdaPlanDetail.in(PlanDetailEntity::getPlanId, planIds);
        List planEntityDetailList = this.planDetailService.list((Wrapper)lambdaPlanDetail);
        Map<Object, Object> reviewDetailMap = new HashMap();
        Map<Object, Object> orderDetailMap = new HashMap();
        Map<Object, Object> reviewDetailChildEntityMap = new HashMap();
        ArrayList planDetailList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)planEntityDetailList)) {
            LambdaQueryWrapper lambdaReviewEntity = Wrappers.lambdaQuery();
            lambdaReviewEntity.in(ReviewEntity::getProjectId, new Object[]{projectId});
            ReviewEntity reviewEntityOne = (ReviewEntity)((Object)super.getOne((Wrapper)lambdaReviewEntity));
            if (reviewEntityOne != null) {
                LambdaQueryWrapper lambdaReviewDetailEntity = Wrappers.lambdaQuery();
                lambdaReviewDetailEntity.eq(ReviewDetailEntity::getReviewId, (Object)reviewEntityOne.getId());
                List reviewDetailEntities = this.reviewDetailService.list((Wrapper)lambdaReviewDetailEntity);
                reviewDetailMap = reviewDetailEntities.stream().filter(map -> map.getParentId() == null).collect(Collectors.groupingBy(s -> s.getMaterialId() + "-" + s.getWbsId()));
                List reviewDetailIds = reviewDetailEntities.stream().filter(map -> map.getParentId() == null).map(BaseEntity::getId).collect(Collectors.toList());
                reviewDetailChildEntityMap = reviewDetailEntities.stream().filter(map -> map.getParentId() != null).collect(Collectors.toMap(ReviewDetailEntity::getPlanDetailId, Function.identity()));
                LambdaQueryWrapper lambdaOrderEntity = Wrappers.lambdaQuery();
                lambdaOrderEntity.in(OrderEntity::getProjectId, new Object[]{projectId});
                List orderEntityList = this.orderService.list((Wrapper)lambdaOrderEntity);
                if (CollectionUtils.isNotEmpty((Collection)orderEntityList)) {
                    List orderIds = orderEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    LambdaQueryWrapper lambdaOrderDetailEntity = Wrappers.lambdaQuery();
                    lambdaOrderDetailEntity.in(OrderDetailEntity::getReviewDetailId, reviewDetailIds);
                    lambdaOrderDetailEntity.in(OrderDetailEntity::getOrderId, orderIds);
                    List orderDetailEntityList = this.orderDetailService.list((Wrapper)lambdaOrderDetailEntity);
                    if (CollectionUtils.isNotEmpty((Collection)orderDetailEntityList)) {
                        orderDetailMap = orderDetailEntityList.stream().collect(Collectors.groupingBy(OrderDetailEntity::getReviewDetailId));
                    }
                }
            }
            Map planMap = planEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map<String, List<PlanDetailEntity>> map2 = planEntityDetailList.stream().collect(Collectors.groupingBy(s -> s.getMaterialId().toString() + '-' + s.getWbsId()));
            HashMap finalReviewDetailMap = reviewDetailMap;
            HashMap finalOrderDetailMap = orderDetailMap;
            HashMap finalReviewDetailChildEntityMap = reviewDetailChildEntityMap;
            map2.forEach((key, value) -> {
                ReviewDetailVO reviewDetailVO = (ReviewDetailVO)BeanMapper.map(value.stream().findFirst().get(), ReviewDetailVO.class);
                BigDecimal planNum = value.stream().map(PlanDetailEntity::getNums).reduce(BigDecimal.ZERO, BigDecimal::add);
                reviewDetailVO.setPlanNum(planNum);
                reviewDetailVO.setId(Long.valueOf(IdWorker.getId()));
                reviewDetailVO.setCreateTime(null);
                reviewDetailVO.setCreateUserCode(null);
                reviewDetailVO.setUpdateTime(null);
                reviewDetailVO.setUpdateUserCode(null);
                reviewDetailVO.setReviewId(reviewEntityOne == null ? null : reviewEntityOne.getId());
                if (finalReviewDetailMap.containsKey(key)) {
                    List reviewDetailEntities = (List)finalReviewDetailMap.get(key);
                    ReviewDetailEntity reviewDetailEntity = (ReviewDetailEntity)((Object)((Object)reviewDetailEntities.stream().findFirst().get()));
                    reviewDetailVO.setReviewNum(reviewDetailEntity.getReviewNum());
                    reviewDetailVO.setRationRate(reviewDetailEntity.getRationRate());
                    reviewDetailVO.setRationNum(reviewDetailEntity.getRationNum());
                    reviewDetailVO.setTargetRate(reviewDetailEntity.getTargetRate());
                    reviewDetailVO.setTargetNum(reviewDetailEntity.getTargetNum());
                    reviewDetailVO.setOccupyNum(reviewDetailEntity.getOccupyNum());
                    reviewDetailVO.setPlanId(null);
                    reviewDetailVO.setCheckNum(null);
                    reviewDetailVO.setTargetId(reviewDetailEntity.getId());
                    reviewDetailVO.setChangeType(ChangeTypeEnum.\u53d8\u66f4\u9879.getCode());
                    if (finalOrderDetailMap.containsKey(reviewDetailEntity.getId())) {
                        List orderDetailEntityList = (List)finalOrderDetailMap.get(reviewDetailEntity.getId());
                        BigDecimal checkNum = orderDetailEntityList.stream().filter(s -> s.getCheckNumsSum() != null).map(OrderDetailEntity::getCheckNumsSum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal orderNum = orderDetailEntityList.stream().filter(s -> s.getOrderNumsSum() != null).map(OrderDetailEntity::getOrderNumsSum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        reviewDetailVO.setOrderNum(orderNum);
                        reviewDetailVO.setCheckNum(checkNum);
                    }
                } else {
                    reviewDetailVO.setId(Long.valueOf(IdWorker.getId()));
                    reviewDetailVO.setChangeType(ChangeTypeEnum.\u589e\u8865\u9879.getCode());
                }
                List reviewDetailVOS = BeanMapper.mapList((Iterable)value, ReviewDetailVO.class);
                for (ReviewDetailVO reviewDetailChild : reviewDetailVOS) {
                    reviewDetailChild.setPlanDetailId(reviewDetailChild.getId());
                    reviewDetailChild.setPlanName(((PlanEntity)((Object)((Object)planMap.get(reviewDetailChild.getPlanId())))).getPlanName());
                    reviewDetailChild.setPlanBillCode(((PlanEntity)((Object)((Object)planMap.get(reviewDetailChild.getPlanId())))).getBillCode());
                    reviewDetailChild.setPlanEmployeeName(((PlanEntity)((Object)((Object)planMap.get(reviewDetailChild.getPlanId())))).getEmployeeName());
                    reviewDetailChild.setParentId(reviewDetailVO.getId());
                    reviewDetailChild.setPlanNum(reviewDetailChild.getNums());
                    reviewDetailChild.setReviewId(reviewEntityOne == null ? null : reviewEntityOne.getId());
                    reviewDetailChild.setId(Long.valueOf(IdWorker.getId()));
                    if (finalReviewDetailChildEntityMap.containsKey(reviewDetailChild.getPlanDetailId())) {
                        ReviewDetailEntity reviewDetailEntity = (ReviewDetailEntity)((Object)((Object)finalReviewDetailChildEntityMap.get(reviewDetailChild.getPlanDetailId())));
                        reviewDetailChild.setReviewNum(reviewDetailEntity.getReviewNum());
                        reviewDetailChild.setTargetId(reviewDetailEntity.getId());
                        reviewDetailChild.setChangeType(ChangeTypeEnum.\u53d8\u66f4\u9879.getCode());
                        continue;
                    }
                    reviewDetailChild.setChangeType(ChangeTypeEnum.\u589e\u8865\u9879.getCode());
                }
                reviewDetailVO.setChildren(reviewDetailVOS);
                planDetailList.add(reviewDetailVO);
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", planDetailList);
    }

    @Override
    public ReviewVO queryDetail(Long id) {
        ReviewEntity entity = (ReviewEntity)((Object)super.selectById((Serializable)id));
        ReviewVO vo = (ReviewVO)BeanMapper.map((Object)((Object)entity), ReviewVO.class);
        List reviewDetailList = vo.getReviewDetailList();
        Map<Long, List<ReviewDetailVO>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailVO::getParentId));
        List reviewDetailVOS = reviewDetailList.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());
        for (ReviewDetailVO reviewDetailVO : reviewDetailVOS) {
            List<ReviewDetailVO> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        vo.setReviewDetailList(reviewDetailVOS);
        LambdaQueryWrapper hisEntity = Wrappers.lambdaQuery();
        hisEntity.in(ReviewChangeHisEntity::getSourceReviewId, new Object[]{id});
        List reviewChangeHisEntities = this.reviewChangeHisService.list((Wrapper)hisEntity);
        if (CollectionUtils.isNotEmpty((Collection)reviewChangeHisEntities)) {
            List reviewChangeHisVOS = BeanMapper.mapList((Iterable)reviewChangeHisEntities, ReviewChangeHisVO.class);
            vo.setReviewChangeHisList(reviewChangeHisVOS);
        }
        return vo;
    }
}

