/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IWeighReportService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.CheckWeighVO;
import com.ejianc.business.wzxt.vo.WeighQueryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"swWeighReport"})
public class SwWeighReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${smartWeigh.addr}")
    private String SUPPLIER_HTTP;
    @Autowired
    private IWeighReportService weighReportService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckWeighVO>> queryList(@RequestBody QueryParam param) {
        String parameterStr;
        String url;
        CommonResponse<Object> response;
        WeighQueryVO queryVO = new WeighQueryVO();
        queryVO.setOrgId(InvocationInfoProxy.getOrgId());
        queryVO.setPage(Integer.valueOf(param.getPageIndex()));
        queryVO.setRows(Integer.valueOf(param.getPageSize()));
        LinkedHashMap orderMap = param.getOrderMap();
        String order = String.valueOf(orderMap.keySet().toArray()[0]);
        queryVO.setSort(order);
        queryVO.setOrder((String)orderMap.get(order));
        Parameter grossTime = (Parameter)param.getParams().get("grossTime");
        if (null != grossTime) {
            String grossTimeValue = String.valueOf(grossTime.getValue());
            String[] split = grossTimeValue.split(",");
            queryVO.setBeginTime(split[0]);
            queryVO.setEndTime(split[1]);
        }
        if (!(response = this.doPostHttp(url = this.SUPPLIER_HTTP + "/el/sw/weigh/projectOrOrg/list", parameterStr = JSONObject.toJSON((Object)queryVO).toString())).isSuccess()) {
            throw new BusinessException("\u8c03\u7528\u78c5\u5355\u670d\u52a1\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)String.valueOf(response.getData()));
        List weighVOS = JSONObject.parseArray((String)String.valueOf(jsonObject.get((Object)"records")), CheckWeighVO.class);
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)((Integer)jsonObject.get((Object)"total")).intValue());
        pageData.setRecords(weighVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private CommonResponse<Object> doPostHttp(String url, String parameterStr) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            try {
                this.logger.info("------------  url\uff1a" + url + "  ------------");
                this.logger.info("------------  \u5165\u53c2\uff1a" + parameterStr + "  ------------");
                String back = HttpTookit.postByJson(url, parameterStr, headers);
                JSONObject jsonBack = JSONObject.parseObject((String)back);
                if ("200".equals(jsonBack.getString("code"))) {
                    this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                    return CommonResponse.success((Object)jsonBack.get((Object)"body"));
                }
                this.logger.error("------------  \u8bf7\u6c42\u5931\u8d25\uff01message = " + jsonBack.getString("message") + "  ------------");
                return CommonResponse.error((String)jsonBack.getString("message"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
            }
        }
        this.logger.error("\u83b7\u53d6token\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        String parameterStr;
        String url;
        CommonResponse<Object> swResponse;
        WeighQueryVO queryVO = new WeighQueryVO();
        queryVO.setOrgId(InvocationInfoProxy.getOrgId());
        queryVO.setPage(Integer.valueOf(param.getPageIndex()));
        queryVO.setRows(Integer.valueOf(param.getPageSize()));
        LinkedHashMap orderMap = param.getOrderMap();
        String order = String.valueOf(orderMap.keySet().toArray()[0]);
        queryVO.setSort(order);
        queryVO.setOrder((String)orderMap.get(order));
        Parameter grossTime = (Parameter)param.getParams().get("grossTime");
        if (null != grossTime) {
            String grossTimeValue = String.valueOf(grossTime.getValue());
            String[] split = grossTimeValue.split(",");
            queryVO.setBeginTime(split[0]);
            queryVO.setEndTime(split[1]);
        }
        if (!(swResponse = this.doPostHttp(url = this.SUPPLIER_HTTP + "/el/sw/weigh/projectOrOrg/list", parameterStr = JSONObject.toJSON((Object)queryVO).toString())).isSuccess()) {
            throw new BusinessException("\u8c03\u7528\u78c5\u5355\u670d\u52a1\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)String.valueOf(swResponse.getData()));
        List weighVOS = JSONObject.parseArray((String)String.valueOf(jsonObject.get((Object)"records")), CheckWeighVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", weighVOS);
        ExcelExport.getInstance().export("swWeighReportExport.xlsx", beans, response);
    }
}

