/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="plan")
public class PlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${mro.addr}")
    private String addr;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPlanService planService;
    @Autowired
    private ThirdSystemUtils thirdSystemUtils;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return this.planService.pushToMro(billId);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(billId));
        if (MaterialTypeEnum.MRO.getCode() == planEntity.getMaterialType()) {
            HashMap<String, String> headers = new HashMap<String, String>();
            this.thirdSystemUtils.getMroSign(headers);
            if (StringUtils.isBlank((CharSequence)planEntity.getHistoryId())) {
                throw new BusinessException("\u8be5\u8ba1\u5212MRO\u4e3b\u952e\u4e3a\u7a7a");
            }
            String mroUrl = this.addr + "/iec/v1/purchase_plan/update/status";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)planEntity.getHistoryId());
            jsonObject.put("originStatus", (Object)("0".equals(planEntity.getPlanFlag()) ? "OFF" : "ON"));
            jsonObject.put("targetStatus", (Object)"DELETED");
            try {
                String responseStr = HttpTookit.postByJson(mroUrl, jsonObject.toJSONString(), headers);
                this.logger.info("afterAbstainingProcessor " + responseStr);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (200 != json.getInteger("code") || !json.getBoolean("success").booleanValue()) {
                    throw new BusinessException(json.getString("message"));
                }
                this.logger.info("\u5220\u9664MRO\u8ba1\u5212\u6210\u529f");
            }
            catch (Exception e) {
                throw new BusinessException(e.getMessage());
            }
        }
        return CommonResponse.success();
    }
}

