package com.ejianc.business.wzxt.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 使用计划实体
 *
 * @author generator
 *
 */
 @TableName("ejc_wzxt_plan")
public class PlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="plan_name")
    private java.lang.String planName; // 使用计划名称
    @TableField(value="bill_code")
    private java.lang.String billCode; // 计划编码
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 经办人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 经办人名称
    @TableField(value="plan_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date planDate; // 计划使用日期
    @TableField(value="construction")
    private java.lang.String construction; // 施工部位
    @TableField(value="memo")
    private java.lang.String memo; // 备注
    @TableField(value="material_name")
    private java.lang.String materialName; // 物资名称
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date createDate; // 创建日期
    @TableField(value="project_source_id")
    private java.lang.String projectSourceId; // 项目来源id
    @TableField(value="plan_flag")
    private java.lang.String planFlag; // 是否开启计划
    @TableField(value="use_state")
    private Integer useState; // 是否被引用 0-未引用 1-引用

    @TableField(value="org_source_id")
    private java.lang.String orgSourceId; // 组织来源ID
    @TableField(value="employee_telephone")
    private java.lang.String employeeTelephone; // 经办人电话
    @TableField(value="parent_org_id")
    private java.lang.Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_source_id")
    private java.lang.String parentOrgSourceId; // 上级组织来源id
    @TableField(value="history_flag")
    private java.lang.Boolean historyFlag; // 是否历史数据
    @TableField(value="history_id")
    private java.lang.String historyId; // 来源主键
    @TableField(value="history_system")
    private java.lang.String historySystem; // 来源系统
    @TableField(value="material_type")
    private java.lang.Integer materialType; //
    @TableField(value="def1")
    private java.lang.String def1; // 自定义字段
    @TableField(value="def2")
    private java.lang.String def2; // 自定义字段
    @TableField(value="def3")
    private java.lang.String def3; // 自定义字段
    @TableField(value="def4")
    private java.lang.String def4; // 自定义字段
    @TableField(value="def5")
    private java.lang.String def5; // 自定义字段

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }

    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }

    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }

    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }

    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    public Boolean getHistoryFlag() {
        return historyFlag;
    }

    public void setHistoryFlag(Boolean historyFlag) {
        this.historyFlag = historyFlag;
    }

    public String getHistoryId() {
        return historyId;
    }

    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }

    public String getHistorySystem() {
        return historySystem;
    }

    public void setHistorySystem(String historySystem) {
        this.historySystem = historySystem;
    }

    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="planDetailService",pidName = "planId")
    private List<PlanDetailEntity> planDetail = new ArrayList<>();

    public String getPlanFlag() {
        return planFlag;
    }

    public void setPlanFlag(String planFlag) {
        this.planFlag = planFlag;
    }

    public Integer getUseState() {
        return useState;
    }

    public void setUseState(Integer useState) {
        this.useState = useState;
    }

    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }

    public String getEmployeeTelephone() {
        return employeeTelephone;
    }

    public void setEmployeeTelephone(String employeeTelephone) {
        this.employeeTelephone = employeeTelephone;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }



    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public List<PlanDetailEntity> getPlanDetail() {
        return planDetail;
    }

    public void setPlanDetail(List<PlanDetailEntity> planDetail) {
        this.planDetail = planDetail;
    }

    /**
     * 使用计划名称
     */
    public java.lang.String getPlanName() {
        return planName;
    }

    /**
     * 使用计划名称
     */
    public void setPlanName(java.lang.String planName) {
        this.planName = planName;
    }
    /**
     * 计划编码
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 计划编码
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 计划使用日期
     */
    public java.util.Date getPlanDate() {
        return planDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanDate(java.util.Date planDate) {
        this.planDate = planDate;
    }
    /**
     * 施工部位
     */
    public java.lang.String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(java.lang.String construction) {
        this.construction = construction;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }

}
