package com.ejianc.business.wzxt.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.wzxt.bean.TemplateContentEntity;
/**
 * 物资验收模板实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_wzxt_template")
public class TemplateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="template_code")
    private String billCode; // 模板编码
    @TableField(value="template_name")
    private String templateName; // 模板名称
    @TableField(value="material_id")
    private Long materialId; // 物资主键
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资类别ID
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资分类编码
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资分类名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="memo")
    private String memo; // 说明
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_source_id")
    private String orgSourceId; // 组织来源ID
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_telephone")
    private Long employeeTelephone; // 经办人电话
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_date")
    private java.util.Date createDate; // 编制日期
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="templateContentService",pidName = "templateId")
    private List<TemplateContentEntity> templateContentEntityList = new ArrayList<>(); // 物资验收模板子表
    

    /**
     * 模板编码
     */
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
/**
     * 模板编码
     */
    /**
     * 模板名称
     */
    public String getTemplateName() {
        return templateName;
    }

    /**
     * 模板名称
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资类别ID
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别ID
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资分类编码
     */
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    /**
     * 物资分类编码
     */
    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 说明
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 说明
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 组织ID
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织ID
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织来源ID
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源ID
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 上级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人电话
     */
    public Long getEmployeeTelephone() {
        return employeeTelephone;
    }

    /**
     * 经办人电话
     */
    public void setEmployeeTelephone(Long employeeTelephone) {
        this.employeeTelephone = employeeTelephone;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 编制日期
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }

    public List<TemplateContentEntity> getTemplateContentEntityList() {
        return templateContentEntityList;
    }

    public void setTemplateContentEntityList(List<TemplateContentEntity> templateContentEntityList) {
        this.templateContentEntityList = templateContentEntityList;
    }
}
