package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CtPlanEntity;
import com.ejianc.business.wzxt.service.ICtPlanService;
import com.ejianc.business.wzxt.vo.ConCheckVO;
import com.ejianc.business.wzxt.vo.CtPlanRefVO;
import com.ejianc.business.wzxt.vo.CtPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 消耗材总控计划实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("ctPlan")
public class CtPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICtPlanService service;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CtPlanVO> saveOrUpdate(@RequestBody CtPlanVO saveorUpdateVO) {
    	CtPlanEntity entity = BeanMapper.map(saveorUpdateVO, CtPlanEntity.class);
    	service.saveOrUpdate(entity, false);
    	CtPlanVO vo = BeanMapper.map(entity, CtPlanVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CtPlanVO> queryDetail(Long id) {
    	CtPlanEntity entity = service.selectById(id);
    	CtPlanVO vo = BeanMapper.map(entity, CtPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CtPlanVO> vos) {
        service.removeByIds(vos.stream().map(CtPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description 根据项目主键和物料主键查询总控数量和累计进场量
     * @Param [ids]
     */
    @RequestMapping(value = "/getNumByProjectId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ConCheckVO>> getNumByProjectId(@RequestBody ConCheckVO conCheckVO) {
        List<ConCheckVO> list = service.getNumByProjectId(conCheckVO);
        return CommonResponse.success("成功！",list);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CtPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if(null!=orgId&&orgId>0){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }else{
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if(!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<CtPlanEntity> page = service.queryPage(param,false);
        IPage<CtPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CtPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 总控计划参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/controlPlanRef")
    @ResponseBody
    public CommonResponse<JSONObject> controlPlanRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                     @RequestParam(defaultValue = "10") Integer pageSize,
                                                     @RequestParam(value = "condition", required = false) String condition,
                                                     @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        Page<CtPlanRefVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<CtPlanRefVO> list = service.getControlPlan(page,wrapper,projectId,InvocationInfoProxy.getTenantid());
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

}
