package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.ProjectWbsEntity;
import com.ejianc.business.wzxt.service.IProjectWbsService;
import com.ejianc.business.wzxt.vo.ProjectWbsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 项目WBS
 *
 * @author generator
 */
@Controller
@RequestMapping("projectWbs")
public class ProjectWbsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectWbsService service;

    @Autowired
    private IProjectApi projectApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectWbsVO> saveOrUpdate(@RequestBody ProjectWbsVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectWbsVO> queryDetail(Long id) {
        ProjectWbsEntity entity = service.selectById(id);
        ProjectWbsVO vo = BeanMapper.map(entity, ProjectWbsVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody ProjectWbsVO projectWbsVO) {
        List<Long> ids = projectWbsVO.getIds();
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                LambdaQueryWrapper<ProjectWbsEntity> lambda = Wrappers.<ProjectWbsEntity>lambdaQuery();
                lambda.eq(ProjectWbsEntity::getParentId, id);
                List<ProjectWbsEntity> projectWbsEntities = service.list(lambda);
                if (CollectionUtils.isNotEmpty(projectWbsEntities)) {
                    return CommonResponse.error("所选数据包含下级,禁止删除!");
                }
            }
            service.removeByIds(ids);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

     /*   UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            List<Long> longs = Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            //没有组织则设定为当前用户组织
            if(!param.getParams().containsKey("orgId")){
                param.getParams().put("orgId", new Parameter(QueryParam.IN, longs));
            }
        }else {//pc端查询
            authOrgIds = String.valueOf(InvocationInfoProxy.getOrgId());
            //没有组织则设定为当前用户组织
            if(!param.getParams().containsKey("orgId")){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, authOrgIds));
            }
        }*/

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<ProjectWbsEntity> wbsEntityList = service.queryList(param, false);

        //如果当前项目没有wbs，则需要预置一个
        if (param.getParams().containsKey("projectId")) {
            Parameter projectIdParam = param.getParams().get("projectId");
            if (projectIdParam.getValue() != null) {
                Long projectId = Long.valueOf(projectIdParam.getValue().toString());
                QueryWrapper<ProjectWbsEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("project_id", projectId);
                int count = service.count(queryWrapper);
                if (count == 0) {
                    List<Long> list = new ArrayList<>();
                    list.add(projectId);
                    CommonResponse<List<ProjectRegisterVO>> projectByIds = projectApi.queryProjectByIds(list);
                    if (!projectByIds.isSuccess()){
                        throw new BusinessException("获取项目信息失败!");
                    }
                    ProjectRegisterVO projectRegisterVO = projectByIds.getData().get(0);
                    long id = IdWorker.getId();
                    ProjectWbsVO projectWbsVO = new ProjectWbsVO();
                    projectWbsVO.setId(id);
                    projectWbsVO.setCode(projectRegisterVO.getCode());
                    projectWbsVO.setName(projectRegisterVO.getName());
                    projectWbsVO.setProjectId(projectId);
                    projectWbsVO.setOrgId(projectRegisterVO.getOrgId());
                    projectWbsVO.setEnabled(1);
                    projectWbsVO.setInnerCode(String.valueOf(id));
                    ProjectWbsEntity projectWbsEntity = BeanMapper.map(projectWbsVO, ProjectWbsEntity.class);
                    boolean b = service.saveOrUpdate(projectWbsEntity);
                    if (b) {
                        wbsEntityList.add(projectWbsEntity);
                    }
                }
            }
        }

        List<Map> resultMapList = BeanMapper.mapList(wbsEntityList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));

        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectWbsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectWbs-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "projectWbs-export.xlsx", "合同清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Long projectId) {
        return service.excelImport(request, response, projectId);
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ProjectWbsVO> importVOS) {
        return CommonResponse.success((String) service.saveImportExcel(request, importVOS));
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectWbsData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refProjectWbsData(@RequestParam(value = "searchText", required = false) String searchText,
                                                       @RequestParam(value = "condition", required = false) String condition
    ) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setSearchText(searchText);
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));

        Long projectId = null;
        String projectSourceId = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("projectSourceId")) {
                projectSourceId =conditionMap.get("projectSourceId").toString();
            }
        }

        List<ProjectWbsEntity> wbsEntityList = service.queryList(param, false);

        //如果当前项目没有wbs，则需要预置一个
        if (projectId != null) {
            QueryWrapper<ProjectWbsEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id", projectId);
            int count = service.count(queryWrapper);
            if (count == 0) {
                CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectApi.queryProjectBySourceId(projectSourceId);
                if (!projectRegisterVOCommonResponse.isSuccess()){
                    throw new BusinessException("获取项目信息失败!");
                }
                ProjectRegisterVO projectRegisterVO = projectRegisterVOCommonResponse.getData();
                long id = IdWorker.getId();
                ProjectWbsVO projectWbsVO = new ProjectWbsVO();
                projectWbsVO.setId(id);
                projectWbsVO.setCode(projectRegisterVO.getCode());
                projectWbsVO.setName(projectRegisterVO.getName());
                projectWbsVO.setProjectId(projectId);
                projectWbsVO.setOrgId(projectRegisterVO.getOrgId());
                projectWbsVO.setEnabled(1);
                projectWbsVO.setInnerCode(String.valueOf(id));
                ProjectWbsEntity projectWbsEntity = BeanMapper.map(projectWbsVO, ProjectWbsEntity.class);
                boolean b = service.saveOrUpdate(projectWbsEntity);
                if (b) {
                    wbsEntityList.add(projectWbsEntity);
                }
            }
        }

        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        LambdaQueryWrapper<ProjectWbsEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProjectWbsEntity::getEnabled, 1);
        queryWrapper.eq(ProjectWbsEntity::getProjectId, projectId);
        List<ProjectWbsEntity> wbsEntities = service.list(queryWrapper);
        Map<Long, ProjectWbsEntity> wbsMap = wbsEntities.stream().collect(Collectors.toMap(ProjectWbsEntity::getId, Function.identity(), (key1, key2) -> key1));
        for (ProjectWbsEntity entity : wbsEntityList) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            String[] innerCode = wbsMap.get(entity.getId()).getInnerCode().split(",");
            String innerCodeName = entity.getName();
            if(innerCode.length > 2){
                for (int i = innerCode.length-2; i > 0; i--) {
                    innerCodeName = innerCodeName + "-" + wbsMap.get(Long.valueOf(innerCode[i])).getName();
                }
            }
            map.put("innerCodeName", innerCodeName);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}
