package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.ScsTypeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 智能称重参照
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("smartweigh")
public class SmartWeighController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${smartWeigh.addr}")
    private String smartWeighHost;

    /**
     * @Description 查参照
     */
    @RequestMapping(value = "/refData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ScsTypeVO>> refData(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        Map<String, String> headers = new HashMap<>();
        IPage<ScsTypeVO> result = null;
        List<ScsTypeVO> all = null;
        List<ScsTypeVO> list = new ArrayList<>();
        try {
            String url = smartWeighHost + "/el/sw/scstype/list";
            String backData =  HttpTookit.get(url, null, headers);
            JSONObject jsonResponse = JSON.parseObject(backData);
            JSONArray datas = (JSONArray) jsonResponse.get("body");
            if (datas != null && datas.size() > 0) {
                all = JSONObject.parseArray(datas.toJSONString(), ScsTypeVO.class);
                for(ScsTypeVO scsTypeVO : all){
                    scsTypeVO.setId(IdWorker.getId());
                    if(StringUtils.isBlank(searchText) || (scsTypeVO.getScsType().contains(searchText))){
                        list.add(scsTypeVO);
                    }
                }
                result =  new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageNumber, pageSize, all.size());
                result.setRecords(list);
            }
        } catch (GeneralSecurityException e) {
            logger.error(e.getMessage());
        } catch (IOException e) {
            logger.error(e.getMessage());
        }
        return CommonResponse.success("查询详情数据成功！",result);
    }

}
