package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.TemplateEntity;
import com.ejianc.business.wzxt.service.ITemplateService;
import com.ejianc.business.wzxt.vo.TemplateVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资验收模板实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("template")
public class TemplateController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ITemplateService service;

    @Resource
    private IMaterialApi iMaterialApi;

    private static final String billCodeRule = "CSCEC5B_WZXT_WZMB";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemplateVO> saveOrUpdate(@RequestBody TemplateVO templateVO) {
       return service.saveOrUpdate(templateVO);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TemplateVO> queryDetail(Long id) {
    	TemplateEntity entity = service.selectById(id);
    	TemplateVO vo = BeanMapper.map(entity, TemplateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     *
     * 通过项目ID物资ID查询模板详情
     * */
    @RequestMapping("/queryTemplateDetail")
    @ResponseBody
    public CommonResponse<List<TemplateVO>>queryTemplateDetail(
           @RequestParam(value = "projectId") Long projectId,
           @RequestParam(value = "materialId")Long materialId
    ){

        List<com.ejianc.business.wzxt.vo.TemplateVO> templateVOS = service.queryTemplateDetail(projectId, materialId);

        if (CollectionUtils.isEmpty(templateVOS)){
            return CommonResponse.error("未找到对应数据");
        }
        return  CommonResponse.success("详情查询成功",templateVOS);
    }
    @RequestMapping
    @ResponseBody
    public CommonResponse<String>queryMaterialTypeById(@RequestParam(value = "materialTypeId")Long materialTypeId){

        TemplateEntity typeId = service.getById(materialTypeId);

        if (typeId==null){
            return CommonResponse.error("数据不存在");
        }
        return CommonResponse.success("查询成功");
    }


    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemplateVO> vos) {
        service.removeByIds(vos.stream().map(TemplateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("templateCode");
        fuzzyFields.add("templateName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeCode");
        fuzzyFields.add("materialTypeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<ComplexParam> complexParams = param.getComplexParams();
        if (complexParams!=null && complexParams.size()>1) {
            Map<String, Parameter> tt = complexParams.get(1).getComplexParams().get(1).getParams();
            if (tt.containsKey("materialTypeId")) {
                //移动端获取materialTypeId参数后，进行转换为所有父级IDs
                List<String> materialTypeIds = (List<String>) tt.get("materialTypeId").getValue();
                List<Long> list = new ArrayList<>();
                materialTypeIds.forEach(e->{
                    list.add(Long.valueOf(e));
                });
                logger.info("分类主键ids-----materialTypeIds"+materialTypeIds);
                CommonResponse<List<MaterialCategoryVO>> listCommonResponse = iMaterialApi.queryCategoryListByChildren(list);
                if(!listCommonResponse.isSuccess()) {
                    return CommonResponse.success("列表查询失败, 查询物料分类信息失败！");
                }
                List<MaterialCategoryVO> MaterialCategoryVOs = listCommonResponse.getData();
                logger.info(listCommonResponse.getMsg()+"分类主键返回-----materialTypepks"+MaterialCategoryVOs);
                List<Long> materialTypepks = MaterialCategoryVOs.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
                logger.info("分类主键-----materialTypepks"+materialTypepks);
                param.getComplexParams().get(1).getComplexParams().get(1).getParams().put("materialTypeId", new Parameter(QueryParam.IN, materialTypepks));
            }
        }
        IPage<TemplateEntity> page = service.queryPage(param,false);
        IPage<TemplateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemplateVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
