package com.ejianc.business.wzxt.controller.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.vo.CheckRestVO;
import com.ejianc.business.wzxt.vo.InstoreDetailVO;
import com.ejianc.business.wzxt.vo.InstoreVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/check/")
public class CheckApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private ICheckService checkService;

	@Autowired
	private ICheckDetailService checkDetailService;

	@RequestMapping(value = "queryCheckRef", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<CheckRestVO>> queryCheckRef(
			@RequestParam(value = "projectSourceId", required=false) String projectSourceId) {
		QueryParam param = new QueryParam();
		if(StringUtils.isNotEmpty(projectSourceId)){
			param.getParams().put("projectSourceId", new Parameter(QueryParam.EQ, projectSourceId));
		}
		param.getParams().put("saveState", new Parameter(QueryParam.EQ, 1));
		param.getParams().put("useState", new Parameter(QueryParam.NE, 1));
		param.getOrderMap().put("checkDate", QueryParam.DESC);
		IPage<CheckEntity> page = checkService.queryPage(param,false);
		IPage<CheckRestVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<CheckEntity> entityList = page.getRecords();
		List<CheckEntity> list = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(entityList)){
			entityList.forEach(entity -> {
				CheckEntity data = checkService.selectById(entity.getId());
				list.add(data);
			});
		}
		pageData.setRecords(BeanMapper.mapList(list, CheckRestVO.class));
		return CommonResponse.success("查询列表数据成功！",pageData);
	}
	
	@RequestMapping(value = "updateUseState", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Boolean> updateUseState(List<InstoreVO> instoreVOList) {
		if(CollectionUtils.isNotEmpty(instoreVOList)){
			List<CheckEntity> editlist = new ArrayList<>();
			instoreVOList.forEach(instoreVO -> {
				CheckEntity entity = checkService.getById(instoreVO.getCheckId());
				if(entity == null){
					logger.error("修改失败！【" + instoreVO.getCheckId() + "】单据不存在！");
					return;
				}
				entity.setUseState(instoreVO.getUseState());
				editlist.add(entity);
			});
			if(CollectionUtils.isNotEmpty(editlist)){
				return CommonResponse.success(checkService.updateBatchById(editlist));
			}
		}
		return CommonResponse.success(true);
	}

	@RequestMapping(value = "updateInstoreNum", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Boolean> updateInstoreNum(@RequestBody List<InstoreVO> instoreVOList) {
		if(CollectionUtils.isNotEmpty(instoreVOList)) {
			List<CheckEntity> editlist = new ArrayList<>();
			instoreVOList.forEach(instoreVO -> {
				CheckEntity entity = checkService.selectById(instoreVO.getCheckId());
				entity.setInstoreId(instoreVO.getInstoreId());
				editlist.add(entity);
			});
			if(CollectionUtils.isNotEmpty(editlist)){
				checkService.updateBatchById(editlist);
			}
			instoreVOList.forEach(instoreVO -> {
				List<InstoreDetailVO> vos = instoreVO.getDetailList();
				if(CollectionUtils.isNotEmpty(vos)){
					List<CheckDetailEntity> list = new ArrayList<>();
					vos.forEach(vo ->{
						CheckDetailEntity detail = checkDetailService.getById(vo.getCheckDetailId());
						BigDecimal instoreNum = detail.getInstoreNum()==null?BigDecimal.ZERO:detail.getInstoreNum();// 入库单数量
						detail.setInstoreNum(instoreNum.add(vo.getInstoreNum()));
						detail.setInstoreId(vo.getInstoreId());
						detail.setInstoreDetailId(vo.getInstoreDetailId());
						list.add(detail);
					});
					if(CollectionUtils.isNotEmpty(list)){
						checkDetailService.updateBatchById(list);
					}
				}
			});
		}
		return CommonResponse.success(true);
	}

}
