package com.ejianc.business.wzxt.mapper;

import com.ejianc.business.wzxt.vo.ExitApplyDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;

import java.util.List;

/**
 * 退场申请单
 * 
 * @author generator
 * 
 */
@Mapper
public interface ExitApplyMapper extends BaseCrudMapper<ExitApplyEntity> {

    /**
     * 新增,参照材料库,查询并补录材料库在场和退场数据信息
     * @Param contractId: 合同id
     * @Param materialIds: 物料id
     * @Param tenantid: 租户id
     * @Return java.util.List<com.ejianc.business.wzxt.vo.ExitApplyDetailVO>
     * @Author songlx
     * @Date 2021-03-22
     **/
    List<ExitApplyDetailVO> queryForAddDeatil(String contractId, List<Long> materialIds, Long tenantId);
}
