package com.ejianc.business.wzxt.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.vo.OrderProjectVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.wzxt.bean.OrderEntity;

import java.util.List;
import java.util.Map;

/**
 * 订单实体
 *
 * @author generator
 *
 */
public interface IOrderService extends IBaseService<OrderEntity> {

    OrderVO saveOrUpdate(OrderVO orderVO);

    Boolean isMatRefCont(String pkContract, String matPkList);

    CommonResponse<OrderVO> updateReceived(OrderVO orderVO);

    CommonResponse<OrderVO>  updateReceivedPart(OrderVO orderVO);

    OrderVO queryDetail(Long id);

    CommonResponse<String> getAccessToken(Map<String, String> headers);

    CommonResponse<String>  pushOrder(Map<String, String> headers,OrderEntity orderEntity);

    CommonResponse<String>  pushDelOrder(Map<String, String> headers,OrderEntity orderEntity);

    String queryContractCodeById(String contractId);

    void delete(List<OrderVO> vos);

    OrderVO updateOrderIgnore(Long id, boolean isIgnore);
}
