package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.wzxt.bean.ReviewEntity;
import com.ejianc.business.wzxt.vo.ReviewChangeHisVO;
import com.ejianc.business.wzxt.vo.ReviewDetailChangeHisVO;
import com.ejianc.business.wzxt.vo.ReviewDetailVO;
import com.ejianc.business.wzxt.vo.ReviewVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.ReviewChangeHisMapper;
import com.ejianc.business.wzxt.bean.ReviewChangeHisEntity;
import com.ejianc.business.wzxt.service.IReviewChangeHisService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 复核变更记录实体
 * 
 * @author generator
 * 
 */
@Service("reviewChangeHisService")
public class ReviewChangeHisServiceImpl extends BaseServiceImpl<ReviewChangeHisMapper, ReviewChangeHisEntity> implements IReviewChangeHisService{

    @Override
    public ReviewChangeHisVO queryDetail(Long id) {
        ReviewChangeHisEntity entity = super.selectById(id);
        ReviewChangeHisVO vo = BeanMapper.map(entity, ReviewChangeHisVO.class);
        List<ReviewDetailChangeHisVO> reviewDetailList = vo.getReviewDetailList();
        Map<Long, List<ReviewDetailChangeHisVO>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailChangeHisVO::getParentId));
        List<ReviewDetailChangeHisVO> reviewDetailVOS = reviewDetailList.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());

        for (ReviewDetailChangeHisVO reviewDetailVO : reviewDetailVOS){
            List<ReviewDetailChangeHisVO> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        vo.setReviewDetailList(reviewDetailVOS);
        return vo;
    }
}
