package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.wzxt.bean.StandEntity;
import com.ejianc.business.wzxt.mapper.StandMapper;
import com.ejianc.business.wzxt.service.IStandService;
import com.ejianc.business.wzxt.vo.StandVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 搅拌站
 *
 * @author generator
 *
 */
@Service("standService")
public class StandServiceImpl extends BaseServiceImpl<StandMapper, StandEntity> implements IStandService{

    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public StandVO saveOrUpdate(StandVO saveOrUpdateVO) {
        StandEntity entity = BeanMapper.map(saveOrUpdateVO, StandEntity.class);
        CommonResponse<OrgVO> oneById = iOrgApi.getOneById(entity.getParentOrgId());
        if (!oneById.isSuccess()){
            if(!oneById.isSuccess()) {
                throw  new BusinessException( "查询组织详情失败！");
            }
        }
        entity.setParentOrgSourceId(oneById.getData().getSourceId());
        if(null != saveOrUpdateVO.getId()){
            StandEntity dbEntity = selectById(saveOrUpdateVO.getId());
            entity.setCreateUserCode(dbEntity.getCreateUserCode());
            entity.setTenantId(dbEntity.getTenantId());
            entity.setCreateTime(dbEntity.getCreateTime());
            entity.setVersion(dbEntity.getVersion());
            entity.setBillState(dbEntity.getBillState());
        }
        entity.setCreateDate(new Date());
        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, StandVO.class);
    }
}
