package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.mapper.WeighDetailMapper;
import com.ejianc.business.wzxt.service.IWeighDetailService;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 智能称重实体明细表
 *
 * @author generator
 *
 */
@Service("weighDetailService")
public class WeighDetailServiceImpl extends BaseServiceImpl<WeighDetailMapper, WeighDetailEntity> implements IWeighDetailService{

    @Override
    public CommonResponse<WeighDetailVO> getdetailByOrgId(Long projectDepartmentId, Long materialId) {
        //查询此项目是否开启智能称重
        LambdaQueryWrapper<WeighDetailEntity> queryWrapper = Wrappers.<WeighDetailEntity>lambdaQuery();
        queryWrapper.eq(WeighDetailEntity::getOrgId, projectDepartmentId);
        queryWrapper.eq(WeighDetailEntity::getMaterialId, materialId);
        WeighDetailEntity weighDetailEntity = super.getOne(queryWrapper);
        if (weighDetailEntity != null) {
            WeighDetailVO vo = BeanMapper.map(weighDetailEntity, WeighDetailVO.class);
            return CommonResponse.success("查询详情数据成功！",vo);
        }else {
            return CommonResponse.success("查询详情数据成功！",null);
        }
    }

    @Override
    public Map<Long, BigDecimal> gettransformRate(Long orgId, Long parentOrgId, List<Long> pkMaterialList) {
        Map<Long, BigDecimal> matMap = new HashMap<>();//项目设置
        Map<Long, BigDecimal> orgmatMap = new HashMap<>();//公司设置
        LambdaQueryWrapper<WeighDetailEntity> lambda = Wrappers.<WeighDetailEntity>lambdaQuery();
        lambda.eq(WeighDetailEntity::getOrgId,parentOrgId);
        lambda.in(WeighDetailEntity::getMaterialId,pkMaterialList);
        List<WeighDetailEntity> detailsOrgs  = this.list(lambda);
        if(CollectionUtils.isNotEmpty(detailsOrgs)){
            orgmatMap = detailsOrgs.stream().collect(Collectors.toMap(WeighDetailEntity::getMaterialId, WeighDetailEntity::getTransformRate));
        }
        lambda = Wrappers.<WeighDetailEntity>lambdaQuery();
        lambda.in(WeighDetailEntity::getMaterialId,pkMaterialList);
        lambda.eq(WeighDetailEntity::getOrgId,orgId);
        List<WeighDetailEntity> details  = this.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            matMap = details.stream().collect(Collectors.toMap(WeighDetailEntity::getMaterialId, WeighDetailEntity::getTransformRate));
        }
        Map<Long, BigDecimal> transMap = new HashMap<>();
        for(Long materialId : pkMaterialList){
            BigDecimal transformRate = matMap.get(materialId);
            if(transformRate == null){
                transformRate = orgmatMap.get(materialId);
            }
            if(transformRate ==null){
                transformRate = BigDecimal.ONE;//如果为空，默认为1
            }
            transMap.put(materialId, transformRate);
        }
        return transMap;
    }
}
