package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.ProjectConfigureEntity;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.PlanDetailRefVO;
import com.ejianc.business.wzxt.vo.PlanDetailVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanDetailVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanMaterialVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.PlanMapper;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.service.IPlanService;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 使用计划实体
 *
 * @author generator
 *
 */
@Service("planService")
public class PlanServiceImpl extends BaseServiceImpl<PlanMapper, PlanEntity> implements IPlanService{
    private static final String WZXT_PLAN_BILL_CODE = "WJ_XELL_PLAN";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IOrgApi orgApi;

    @Value("${mro.addr}")
    private String addr;

    @Autowired
    private ThirdSystemUtils thirdSystemUtils;

    @Autowired
    private IProjectConfigureService projectConfigureService;

    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO planVO) {


        //查询项目部上级组织的的来源id
        CommonResponse<OrgVO> orgParentVo = orgApi.getOneById(planVO.getParentOrgId());
        if(!orgParentVo.isSuccess()) {
            return CommonResponse.success("查询组织详情失败！");
        }

        planVO.setParentOrgSourceId(orgParentVo.getData().getSourceId());
        planVO.setPlanFlag("1");
        planVO.setUseState(0);
        planVO.setHistoryFlag(false);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(planVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_PLAN_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                planVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        PlanEntity entity = BeanMapper.map(planVO, PlanEntity.class);
        //汇总物资明细名称
        List<PlanDetailEntity> planDetail = entity.getPlanDetail();
        String materialName = "";
        List<String> wbsName = new ArrayList<>();


        if(planDetail != null && planDetail.size() > 0){
            Map<String, String> keyMap = new HashMap<>();

            for(PlanDetailEntity applyDetailEntity : planDetail){
                String key = applyDetailEntity.getWbsId()+ "_" + applyDetailEntity.getMaterialId();
                if (keyMap.containsKey(key)){
                    throw new BusinessException("计划明细同一物料同一使用部位有重复,请修改!");
                }
                keyMap.put(key,key);
                materialName = materialName + applyDetailEntity.getMaterialName() + ",";
                if(!wbsName.contains(applyDetailEntity.getWbsName())){
                    wbsName.add(applyDetailEntity.getWbsName());
                }
                if (applyDetailEntity.getNums() != null){
                    BigDecimal nums = applyDetailEntity.getNums() == null ? BigDecimal.ZERO : applyDetailEntity.getNums();
                    BigDecimal occupyNums = applyDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : applyDetailEntity.getOccupyNums();
                    BigDecimal surplusNums = nums.subtract(occupyNums);
                    applyDetailEntity.setSurplusNums(surplusNums);
                    applyDetailEntity.setOccupyNums(occupyNums);
                    applyDetailEntity.setNums(nums);
                }
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            String wbsNames = wbsName.stream().collect(Collectors.joining(","));

            entity.setMaterialName(substring);
            entity.setConstruction(wbsNames);
        }
        planService.saveOrUpdate(entity, false);
        PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<PlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId,QueryWrapper queryWrapper) {
        List<PlanDetailRefVO> planVOList = baseMapper.getPlanByMaterialId(materialListId,queryWrapper);
        return planVOList;
    }

    @Override
    public CommonResponse<String> pushToMro(Long billId) {
        PlanEntity planEntity = planService.selectById(billId);
        if (MaterialTypeEnum.MRO.getCode().equals(planEntity.getMaterialType())) {
            LambdaQueryWrapper<ProjectConfigureEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ProjectConfigureEntity::getProjectId, planEntity.getProjectId());
            ProjectConfigureEntity configureEntity = projectConfigureService.getOne(queryWrapper, false);
            if (null == configureEntity) {
                throw new BusinessException("该项目未关联MRO项目");
            } else {
                SyncMroPlanVO syncMroPlanVO = changePlanToMro(planEntity, configureEntity);
                Map<String, String> headers = new HashMap<>();
                thirdSystemUtils.getMroSign(headers);
                String mroUrl = addr + "/iec/v1/purchase_plan/save";
                try {
                    logger.info("推送MRO实体" + JSONObject.toJSON(syncMroPlanVO).toString());
                    logger.info("推送MRO头部" + JSONObject.toJSONString(headers));
                    String responseStr = HttpTookit.postByJson(mroUrl, JSONObject.toJSON(syncMroPlanVO).toString(), headers);
                    JSONObject json = JSONObject.parseObject(responseStr);
                    logger.info("推送MRO结果" + json.toJSONString());
                    if (200 == json.getInteger("code") && true == json.getBoolean("success")) {
                        String mroId = json.getString("data");
                        planEntity.setHistoryId(mroId);
                        planEntity.setHistorySystem("MRO");
                        planService.saveOrUpdate(planEntity);
                    } else {
                        logger.info(json.toJSONString());
                        throw new BusinessException("推送MRO失败，" + json.get("message"));
                    }
                } catch (Exception e) {
                    logger.info("异常" + e.getMessage());
                    throw new BusinessException(e.getMessage());
                }
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<PlanDetailVO> getPlanNum(Long projectId, Long materialId, Long wbsId) {
        //已提计划量：根据，项目+物资编号+部位汇总累加已经通过审批的计划数量
        BigDecimal planNum = baseMapper.getPlanNum(projectId,materialId,wbsId);
        //获取累计验收量
        BigDecimal checkNum = baseMapper.getCheckNum(projectId,materialId,wbsId);
        PlanDetailVO planDetailVO = new PlanDetailVO();
        planDetailVO.setPlanApproveNum(planNum);
        planDetailVO.setCheckApproveNum(checkNum);

        return CommonResponse.success("查询详情数据成功！",planDetailVO);
    }


    private SyncMroPlanVO changePlanToMro(PlanEntity planEntity, ProjectConfigureEntity configureEntity){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+0800");
        SyncMroPlanVO syncMroPlanVO = new SyncMroPlanVO();
        syncMroPlanVO.setCode(planEntity.getBillCode());
        syncMroPlanVO.setProjectId(Long.valueOf(configureEntity.getMroProjectSourceId()));
        syncMroPlanVO.setStatus("ON");//string 需用计划状态 ON-开启，OFF-关闭，DELETED-删除
        syncMroPlanVO.setThirdId(planEntity.getId().toString());
        syncMroPlanVO.setDescription(planEntity.getMemo());
        syncMroPlanVO.setCreatedAt(sdf.format(planEntity.getCreateDate()));
        if(null != planEntity.getUpdateTime()){
            syncMroPlanVO.setUpdatedAt(sdf.format(planEntity.getUpdateTime()));
        }
        if(CollectionUtils.isNotEmpty(planEntity.getPlanDetail())){
            List<SyncMroPlanDetailVO> syncMroPlanDetailVOS = new ArrayList<>();
            planEntity.getPlanDetail().forEach(detail -> {
                SyncMroPlanMaterialVO syncMaterialVO = new SyncMroPlanMaterialVO();
                syncMaterialVO.setCode(detail.getMaterialCode());
                syncMaterialVO.setName(detail.getMaterialName());
                syncMaterialVO.setSpecification(detail.getSpec());
                syncMaterialVO.setUnit(detail.getUnit());
                syncMaterialVO.setThirdId(detail.getMaterialId().toString());

                SyncMroPlanDetailVO syncDetailVO = new SyncMroPlanDetailVO();
                syncDetailVO.setTotalCount(detail.getNums());
                syncDetailVO.setDescription(detail.getMemo());
                syncDetailVO.setThirdId(detail.getId().toString());
                syncDetailVO.setMaterial(syncMaterialVO);

                syncMroPlanDetailVOS.add(syncDetailVO);
            });
            syncMroPlanVO.setDetails(syncMroPlanDetailVOS);
        }
        return  syncMroPlanVO;
    }
}
