package com.ejianc.business.wzxt.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 节超原因分析
 *
 * @author generator
 *
 */
 @TableName("ejc_wzxt_cause")
public class CauseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_source_id")
    private String orgSourceId; // 组织来源ID
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织
    @TableField(value="parent_org_source_id")
    private String parentOrgSourceId; // 上级组织来源ID
    @TableField(value="duty_person_id")
    private Long dutyPersonId; // 责任人ID
    @TableField(value="duty_person_name")
    private String dutyPersonName; // 责任人
    @TableField(value="duty_section")
    private String dutySection; // 责任工区
    @TableField(value="employee_id")
    private String employeeId; // 经办人ID
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="construction")
    private String construction; // 部位名称
    @TableField(value="exceed_cause")
    private String exceedCause; // 节超原因分析
    @TableField(value="improvement_measure")
    private String improvementMeasure; // 改进措施
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）

    // 节超原因分析子表
    @TableField(exist = false)
    @SubEntity(serviceName="causeDetailService",pidName = "causeId")
    private List<CauseDetailEntity> detailList = new ArrayList<>();


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    public Long getDutyPersonId() {
        return dutyPersonId;
    }

    public void setDutyPersonId(Long dutyPersonId) {
        this.dutyPersonId = dutyPersonId;
    }
    public String getDutyPersonName() {
        return dutyPersonName;
    }

    public void setDutyPersonName(String dutyPersonName) {
        this.dutyPersonName = dutyPersonName;
    }
    public String getDutySection() {
        return dutySection;
    }

    public void setDutySection(String dutySection) {
        this.dutySection = dutySection;
    }
    public String getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public String getExceedCause() {
        return exceedCause;
    }

    public void setExceedCause(String exceedCause) {
        this.exceedCause = exceedCause;
    }
    public String getImprovementMeasure() {
        return improvementMeasure;
    }

    public void setImprovementMeasure(String improvementMeasure) {
        this.improvementMeasure = improvementMeasure;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<CauseDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CauseDetailEntity> detailList) {
        this.detailList = detailList;
    }


}
