package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.wzxtUserProject.api.IWzxtUserProjectRelationApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 发货实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("delivery")
public class DeliveryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IWzxtUserProjectRelationApi wzxtUserProjectRelationApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;

    @Value("${smartWeigh.addr}")
    private String addr;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> saveOrUpdate(@RequestBody DeliveryVO saveorUpdateVO) {

        logger.error("发货信息01:"+saveorUpdateVO.toString());
        logger.error("发货明细主键:"+saveorUpdateVO.getDeliveryDetail().get(0).toString());
        return deliveryService.saveOrUpdate(saveorUpdateVO);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
    	DeliveryEntity entity = deliveryService.selectById(id);
    	DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        try {
            List<String> ids = new ArrayList<>();
            ids.add(entity.getHistoryId());
            List<WeighNumVO> weighNumVOList = getWeighNumInfo(ids);
            if(CollectionUtils.isNotEmpty(weighNumVOList)){
                Map<String, WeighNumVO> weighNumVOMap = weighNumVOList.stream().collect(Collectors.toMap(WeighNumVO::getPkDelivery, Function.identity()));
                WeighNumVO weighNumVO = weighNumVOMap.get(entity.getHistoryId());
                if(null != weighNumVO){
                    vo.setTotalNum(weighNumVO.getTotalNum());
                    vo.setCheckNum(weighNumVO.getCheckNum());
                    vo.setUnCheckNum(weighNumVO.getUnCheckNum());
                }
            }
            //根据发货单主键查询计划的创建人
            LambdaQueryWrapper<DeliveryDetailEntity> lambda = Wrappers.<DeliveryDetailEntity>lambdaQuery();
            lambda.eq(DeliveryDetailEntity::getDeliveryId,id);
            List<DeliveryDetailEntity> details  = deliveryDetailService.list(lambda);
            List<Long> orderDetailsId = details.stream().map(DeliveryDetailEntity::getOrderDetailId).collect(Collectors.toList());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(orderDetailsId)){
                String queryPlanEmployName = orderDetailService.queryPlanEmployName(orderDetailsId,entity.getOrderId());
                vo.setChecker(queryPlanEmployName);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 确认发货
     * @param id
     */
    @RequestMapping(value = "/deliver", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> deliver(Long id) {
        return deliveryService.deliver(id);
    }
    /**
     * @Description queryDetail 关闭发货单
     * @param id
     */
    @RequestMapping(value = "/closeDelivery", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> closeDelivery(Long id) {
        return deliveryService.closeDelivery(id);
    }
    /**
     * 根据订单主键查询,返回发货信息
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetails(@RequestParam Long id) {
        DeliveryVO vo = deliveryService.queryDetails(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/getTransformRate", method = RequestMethod.GET)
    @ResponseBody
    public Map<String, BigDecimal>  getTransformRate(@RequestParam("pkDelivery") String pkDelivery) {
        return deliveryService.getTransformRate(pkDelivery);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        deliveryService.removeByIds(vos.stream().map(DeliveryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("linkName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        CommonResponse<List<ProjectRegisterVO>> childProResp = projectApi.queryProjectByUserId(InvocationInfoProxy.getUserid());
        if(!childProResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(childProResp.getData())){
            childIds.addAll(childProResp.getData().stream().map(ProjectRegisterVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<DeliveryEntity> page = deliveryService.queryPage(param,false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if(null!=page.getRecords()&&CollectionUtils.isNotEmpty(page.getRecords())){
            List<DeliveryVO> DeliveryVOList = BeanMapper.mapList(page.getRecords(), DeliveryVO.class);
            DeliveryVOList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                //发货状态（0-自由态，1-已发货，2-已验收）
                if (vo.getDeliverState() == 0){
                    vo.setDeliverStateName("自由态");
                }
                if (vo.getDeliverState() == 1){
                    vo.setDeliverStateName("已发货");
                }
                if (vo.getDeliverState() == 2){
                    vo.setDeliverStateName("已验收");
                }
            });
            pageData.setRecords(DeliveryVOList);
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表-移动端但验收单
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCheckList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryCheckList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("linkName");
        fuzzyFields.add("billCode");
        param.getParams().put("close_status",new Parameter("eq",0));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
           /* List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }*/
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<DeliveryEntity> page = deliveryService.queryPage(param,false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if(null!=page.getRecords()&&CollectionUtils.isNotEmpty(page.getRecords())){
            List<DeliveryVO> deliveryVOList = BeanMapper.mapList(page.getRecords(), DeliveryVO.class);
            List<String> deliveryIds = deliveryVOList.stream().map(DeliveryVO::getHistoryId).collect(Collectors.toList());
            //根据发货单主键查询磅单
            try {
                List<WeighNumVO> weighNumVOList = getWeighNumInfo(deliveryIds);
                if(CollectionUtils.isNotEmpty(weighNumVOList)){
                    Map<String, WeighNumVO> weighNumVOMap = weighNumVOList.stream().collect(Collectors.toMap(WeighNumVO::getPkDelivery, Function.identity()));
                    deliveryVOList.forEach(delivery -> {
                        WeighNumVO weighNumVO = weighNumVOMap.get(delivery.getHistoryId());
                        if(null != weighNumVO){
                            delivery.setTotalNum(weighNumVO.getTotalNum());
                            delivery.setCheckNum(weighNumVO.getCheckNum());
                            delivery.setUnCheckNum(weighNumVO.getUnCheckNum());
                        }
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            deliveryVOList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                //发货状态（0-自由态，1-已发货，2-已验收）
                if (vo.getDeliverState() == 0){
                    vo.setDeliverStateName("自由态");
                }
                if (vo.getDeliverState() == 1){
                    vo.setDeliverStateName("待验收");
                }
                if (vo.getDeliverState() == 2){
                    vo.setDeliverStateName("已验收");
                }
            });
            pageData.setRecords(deliveryVOList);
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("linkName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            /*List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }*/
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<DeliveryEntity> pageData= deliveryService.queryPage(param,false);
        List<DeliveryVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(),DeliveryVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                //发货状态（0-自由态，1-已发货，2-已验收）
                if (vo.getDeliverState() == 0){
                    vo.setDeliverStateName("自由态");
                }
                if (vo.getDeliverState() == 1){
                    vo.setDeliverStateName("已发货");
                }
                if (vo.getDeliverState() == 2){
                    vo.setDeliverStateName("已验收");
                }
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("deliveryExport.xlsx", beans, response);
    }

    /**
     * 根据订单主键查询,返回发货信息
     *
     * @return
     */
    @RequestMapping(value = "/weighCheck", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> weighCheck(@RequestBody DeliveryCheckVO deliveryCheckVO) throws Exception {
        DeliveryVO vo = deliveryService.weighCheck(deliveryCheckVO);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * 智能称重,根据榜单一键验收
     *
     * @return
     */
    @RequestMapping(value = "/oneKeyCheck", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> oneKeyCheck(@RequestBody DeliveryCheckVO deliveryCheckVO) throws Exception {
        DeliveryVO vo = deliveryService.oneKeyCheck(deliveryCheckVO);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    List<WeighNumVO>  getWeighNumInfo(List<String> pkDeliverys) throws Exception {
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = orderService.getAccessToken(headers);
        if(tokenres.isSuccess()){
            logger.info("获取供方token--"+headers);
            WeighNumQueryVO weighIdsQuery = new WeighNumQueryVO();
            weighIdsQuery.setPkDeliverys(pkDeliverys);
            String url = addr + "/el/sw/weigh/delivery/num";
            String back = null;
            back = HttpTookit.postByJson(url, JSONObject.toJSON(weighIdsQuery).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return JSONArray.parseArray(((JSONArray) jsonBack.get("body")).toJSONString(), WeighNumVO.class);
            }else{
                //调用同步方法失败，输出错误信息
                throw new BusinessException(jsonBack.getString("msg"));
            }
        }else {
            throw new BusinessException("获取token失败,请刷新后重试!");
        }

    }
}
