package com.ejianc.business.wzxt.controller;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.wzxt.bean.RecordEntity;
import com.ejianc.business.wzxt.service.IRecordService;
import com.ejianc.business.wzxt.vo.RecordVO;

/**
 * 修改记录表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("record")
public class RecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IRecordService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RecordVO> saveOrUpdate(@RequestBody RecordVO saveOrUpdateVO) {
    	RecordEntity entity = BeanMapper.map(saveOrUpdateVO, RecordEntity.class);
    	service.saveOrUpdate(entity, false);
    	RecordVO vo = BeanMapper.map(entity, RecordVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RecordVO> queryDetail(Long id) {
    	RecordEntity entity = service.selectById(id);
    	RecordVO vo = BeanMapper.map(entity, RecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RecordVO> vos) {
        service.removeByIds(vos.stream().map(RecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RecordVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<RecordEntity> page = service.queryPage(param,false);
        IPage<RecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RecordVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
