package com.ejianc.business.wzxt.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.service.IYzMaterialService;
import com.ejianc.business.wzxt.service.IYzSupplierService;
import com.ejianc.business.wzxt.util.MathUtil;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/yzwSyncApi/")
public class YzwSyncApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectConfigureService projectConfigureService;

	@Autowired
	private IOrgApi orgApi;

	@Autowired
	private IProjectApi projectApi;

	@Autowired
	private IMaterialApi materialApi;

	@Autowired
	private ISupplierApi supplierApi;

	@Autowired
	private IYzMaterialService yzMaterialService;

	@Autowired
	private IYzSupplierService yzSupplierService;

	@Autowired
	private ICheckService checkService;

	@Autowired
	private ThirdSystemUtils thirdSystemUtils;


	/**
	 * 同步云筑验收单
	 * @return
	 */
	@RequestMapping(path = "/syncYzCheck", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> syncYzCheck(HttpServletRequest request) {
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.DATE, -1);
		String begintime = df.format(calendar.getTime()) + " 00:00:00";
		String endtime = df.format(new Date()) + " 00:00:00";

		// 手动调用时传的时间参数（正式的调度中心可忽略）
		if (request.getParameter("beginTime") != null) {
			begintime = request.getParameter("beginTime");
		}
		if (request.getParameter("endTime") != null) {
			endtime = request.getParameter("endTime");
		}

		Map<String, JSONObject> listJsonMap = queryYzwCheckList(begintime, endtime, thirdSystemUtils);
		logger.info("check list size is " + listJsonMap.size());

		if(listJsonMap.isEmpty()){
			return CommonResponse.success("无数据");
		}
		Map<String, String> headers = new HashMap<>();
		JSONObject queryListJson = new JSONObject();
		queryListJson.put("SysNoList", new ArrayList<>(listJsonMap.keySet()));
		try {
			JSONObject respone = JSONObject.parseObject(thirdSystemUtils.sendYzw(headers, queryListJson, "BaseData.GetInspectList"));
			if(0 == ((Integer)respone.get("Code")) && StringUtils.isNotBlank(respone.getString("Data"))){
				JSONArray jsonArray = respone.getJSONArray("Data");//验收单列表
				for(Object obj : jsonArray){
					JSONObject checkJson = (JSONObject) obj;
					LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
					queryWrapper.eq(CheckEntity::getHistoryId, checkJson.getString("SysNo"));
					List<CheckEntity> checkEntities = checkService.list(queryWrapper);
					CheckEntity checkEntity = CollectionUtils.isNotEmpty(checkEntities) ? checkService.selectById(checkEntities.get(0).getId()) : new CheckEntity();
					syncYzwToCheck(checkJson, listJsonMap, checkEntity);
				}
			}
		}catch (IOException e) {
			logger.info(e.getMessage());
		}
		return CommonResponse.success("保存验收单成功！");
	}

	private Map<String, JSONObject> queryYzwCheckList(String beginTime, String endTime, ThirdSystemUtils systemUtils){
		Map<String, JSONObject> listJsonMap = new HashMap<>();
		Map<String, String> headers = new HashMap<>();
		JSONObject queryListJson = new JSONObject();
		queryListJson.put("DataDateBegin", beginTime);
		queryListJson.put("DataDateEnd", endTime);
		queryListJson.put("LimitRows", 100);
		boolean flag = true;
		int pageNumber = 1;
		try {
			while (flag) {
				queryListJson.put("PageIndex", pageNumber);
				JSONObject respone = JSONObject.parseObject(systemUtils.sendYzw(headers, queryListJson, "BaseData.QueryInspectList"));
				logger.info("query check list result is" + respone.toJSONString());
				if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
					JSONArray jsonArray = respone.getJSONObject("Data").getJSONArray("Rows");
					for(Object obj : jsonArray){
						JSONObject jsonObject = (JSONObject) obj;
						listJsonMap.put(jsonObject.getString("SysNo"), jsonObject);
					}
					if(jsonArray.size() < 100){
						logger.info("normal end pageNumber is "  + pageNumber);
						flag = false;
					}
				}else{
					flag = false;
					logger.info(respone.toJSONString());
					logger.info("no data pageNumber is "  + pageNumber);
				}
				pageNumber++;
			}
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
		return listJsonMap;
	}

	private boolean syncYzwToCheck(JSONObject checkJson, Map<String, JSONObject> listJsonMap, CheckEntity checkEntity){
		if(null != checkEntity.getCheckState() && 1 == checkEntity.getCheckState()){
			logger.info("已有该验收单且验收单已验收");
			return false;
		}
		if(null != checkEntity.getUseState() && 1 == checkEntity.getUseState() && (null == checkEntity.getDrstatus() || 0 == checkEntity.getDrstatus())){
			logger.info("已有该验收单且验收单已推送NC未删除");
			return false;
		}
		String sysNo = checkJson.getString("SysNo");
		JSONObject listJson = listJsonMap.get(sysNo);
		checkEntity.setBillCode(sysNo);
		checkEntity.setYzProjectCode(listJson.getString("ProjectSysNo"));
		checkEntity.setYzProjectName(listJson.getString("ProjectName"));
		Long projectId = projectConfigureService.queryProjectIdBySourceId(listJson.getString("ProjectSysNo"));
		if(null != projectId){
			List<Long> projectIdList = new ArrayList<>();
			projectIdList.add(projectId);
			CommonResponse<List<ProjectRegisterVO>> project = projectApi.queryProjectByIds(projectIdList);
			if(project.isSuccess()){
				ProjectRegisterVO projectRegisterVO = project.getData().get(0);
				checkEntity.setProjectId(projectRegisterVO.getId());
				checkEntity.setProjectSourceId(projectRegisterVO.getSourceId());
				checkEntity.setProjectName(projectRegisterVO.getName());
				checkEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
				checkEntity.setOrgName(projectRegisterVO.getName());
				checkEntity.setParentOrgId(projectRegisterVO.getOrgId());
			}
			CommonResponse<OrgVO> orgVOCommonResponse = orgApi.getOneById(checkEntity.getParentOrgId());
			if(orgVOCommonResponse.isSuccess()){
				OrgVO orgVO = orgVOCommonResponse.getData();
				checkEntity.setParentOrgSourceId(orgVO.getSourceId());
			}
		}
		checkEntity.setYzSupplierCode(listJson.getString("SupplierSysNo"));
		checkEntity.setYzSupplierName(listJson.getString("SupplierName"));
		Long supplierId = yzSupplierService.querySuplIdByYzCode(listJson.getString("SupplierSysNo"));
		if(null != supplierId){
			CommonResponse<SupplierVO> supplierVOCommonResponse = supplierApi.queryById(supplierId);
			if(supplierVOCommonResponse.isSuccess()){
				SupplierVO supplierVO = supplierVOCommonResponse.getData();
				checkEntity.setSupplierId(supplierId);
				checkEntity.setSupplierName(supplierVO.getName());
				checkEntity.setSupplierSourceId(supplierVO.getSourceId());
				checkEntity.setSupplierTenantId(supplierVO.getTenantId());
			}
		}

		checkEntity.setCheckDate(checkJson.getDate("InspectDate"));
//		checkEntity.setEmployeeId(null);
		checkEntity.setEmployeeName(checkJson.getString("InspectUserName"));
		checkEntity.setCreateUserName(checkJson.getString("InspectUserName"));
		checkEntity.setCheckType("1");
		checkEntity.setSaveState(1);
		checkEntity.setCheckState(0);
		checkEntity.setIsRequirement("1");
		checkEntity.setIsStandard("1");
		checkEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
//		checkEntity.setLicensePlate();
		checkEntity.setUseState(0);

		checkEntity.setIsaddrecord("0");
		checkEntity.setIsPurchase("0");
		checkEntity.setSmartStatus("0");
		checkEntity.setDrstatus(0);
		checkEntity.setHistoryId(sysNo);
		checkEntity.setHistorySystem("YZW");
		checkEntity.setSourceType("2");

		Map<String, CheckDetailEntity> map = new HashMap<>();
		if(CollectionUtils.isNotEmpty(checkEntity.getDetailList())){
			map = checkEntity.getDetailList().stream().collect(Collectors.toMap(CheckDetailEntity::getYzSysNo, Function.identity(), (key1, key2) -> key2));
		}
		List<CheckDetailEntity> detailList = new ArrayList<>();
		JSONArray jsonArray = checkJson.getJSONArray("DetailList");
		for (Object obj: jsonArray) {
			JSONObject detailJson = (JSONObject) obj;
			CheckDetailEntity detailEntity = null;
			if (map.containsKey(detailJson.getString("SysNo"))) {
				detailEntity = map.get(detailJson.getString("SysNo"));
			} else {
				detailEntity = new CheckDetailEntity();
			}
			detailEntity.setYzSysNo(detailJson.getString("SysNo"));
			detailEntity.setYzMaterialCode(detailJson.getString("MateSysNo"));
			detailEntity.setYzMaterialName(detailJson.getString("ProductCommonName"));
			detailEntity.setYzUnit(detailJson.getString("UnitName"));
			detailEntity.setYzCheckNumsSum(detailJson.getBigDecimal("InspectQuantity"));
			detailEntity.setMemo(detailJson.getString("InspectMemo"));
			YzMaterialEntity yzMaterialEntity = yzMaterialService.queryMaterialIdByYzCode(detailJson.getString("MateSysNo"));
			if(null != yzMaterialEntity){
				List<Long> materialIdList = new ArrayList<>();
				materialIdList.add(yzMaterialEntity.getMaterialId());
				CommonResponse<List<MaterialVO>> queryMaterialByIds = materialApi.queryMaterialByIds(materialIdList);
				if(queryMaterialByIds.isSuccess()){
					MaterialVO materialVO = queryMaterialByIds.getData().get(0);
					detailEntity.setMaterialId(yzMaterialEntity.getMaterialId());
					detailEntity.setMaterialName(materialVO.getName());
					detailEntity.setMaterialTypeId(materialVO.getCategoryId());
					detailEntity.setMaterialTypeName(materialVO.getCategoryName());
					detailEntity.setMaterialCode(materialVO.getCode());
					detailEntity.setUnit(materialVO.getUnitName());
					detailEntity.setSpec(materialVO.getSpec());
					detailEntity.setMaterialSourceId(materialVO.getSourceId());
				}
				detailEntity.setCheckNumsSum(MathUtil.safeMultiply(detailEntity.getYzCheckNumsSum(), yzMaterialEntity.getCoefficient()));
			}
			detailList.add(detailEntity);
		}
		checkEntity.setDetailList(detailList);
		return  checkService.saveOrUpdate(checkEntity, false);
	}

}
