package com.ejianc.business.wzxt.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ChangeStatusEnum {


    UNCHANGE_STATE(0, "未变更"),
    CHANGEING_STATE(1, "变更中"),
    CHANGEED_STATE(2, "已变更");


    private final Integer changeStateCode;
    private final String description;
    private static Map<Integer, ChangeStatusEnum> enumMap = new HashMap();

    private ChangeStatusEnum(Integer changeStateCode, String description) {
        this.changeStateCode = changeStateCode;
        this.description = description;
    }

    public Integer getChangeStateCode() {
        return this.changeStateCode;
    }

    public String getDescription() {
        return this.description;
    }

    public static ChangeStatusEnum getEnumByStateCode(Integer changeStateCode) {
        return (ChangeStatusEnum)enumMap.get(changeStateCode);
    }

    static {
        enumMap = (Map)EnumSet.allOf(ChangeStatusEnum.class).stream().collect(Collectors.toMap(ChangeStatusEnum::getChangeStateCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
