package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.CauseDetailEntity;
import com.ejianc.business.wzxt.service.IReviewDetailService;
import com.ejianc.business.wzxt.vo.CauseRtVO;
import com.ejianc.business.wzxt.vo.CauseVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.CauseMapper;
import com.ejianc.business.wzxt.bean.CauseEntity;
import com.ejianc.business.wzxt.service.ICauseService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 节超原因分析
 *
 * @author generator
 *
 */
@Service("causeService")
public class CauseServiceImpl extends BaseServiceImpl<CauseMapper, CauseEntity> implements ICauseService{

    @Autowired
    private IOrgApi orgApi;

    private static final String WJ_WZXT_CAUSE = "CAUSE_CODE";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private IReviewDetailService reviewDetailService;


    @Override
    public CauseVO saveOrUpdate(CauseVO saveOrUpdateVO) {
        CauseEntity entity = BeanMapper.map(saveOrUpdateVO, CauseEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WJ_WZXT_CAUSE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        boolean autCommitFlag = true;
        //处理表头部位信息
        StringBuffer stringBuffer = new StringBuffer();
        for(CauseDetailEntity causeDetailEntity : entity.getDetailList()){
            if(StringUtils.isNotEmpty(causeDetailEntity.getConstructionDetail())){
                stringBuffer.append(causeDetailEntity.getConstructionDetail()).append(",");
            }
            if (ComputeUtil.isLessThan(causeDetailEntity.getExceedRate(), BigDecimal.ZERO)) {
                autCommitFlag = false;
            }
        }

        if (autCommitFlag && null == saveOrUpdateVO.getId()) {
            entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            entity.setExceedCause("未超量，在可控范围内，继续加强管控。");
            for (int i = 0; i < entity.getDetailList().size(); i++) {
                CauseDetailEntity causeDetailEntity = entity.getDetailList().get(i);
                List<PlanVO> planVOS = reviewDetailService.queryPlanInfo(causeDetailEntity.getProjectId(), causeDetailEntity.getWbsId(), causeDetailEntity.getMaterialId());
                PlanVO planVO = planVOS.get(0);
                if (i == 0) {
                    entity.setDutyPersonId(planVO.getEmployeeId());
                    entity.setDutyPersonName(planVO.getEmployeeName());
                }
                causeDetailEntity.setDutyPersonDetailId(planVO.getEmployeeId());
                causeDetailEntity.setDutyPersonDetailName(planVO.getEmployeeName());
                causeDetailEntity.setExceedCauseDetail("未超量，在可控范围内，继续加强管控。");
            }
        }

        if(stringBuffer != null ){
            entity.setConstruction(stringBuffer.substring(0, stringBuffer.length()-1));
        }

        List<Long> projectId = new ArrayList<>();
        projectId.add(entity.getProjectId());
        CommonResponse<List<ProjectRegisterVO>> projectRegisterVO = iProjectApi.queryProjectByIds(projectId);
        if(projectRegisterVO.getCode() == 0 && projectRegisterVO.getData()!= null){
            ProjectRegisterVO registerVO = projectRegisterVO.getData().get(0);
            entity.setOrgId(registerVO.getProjectDepartmentId());
            CommonResponse<OrgVO> orgVo = orgApi.detailById(entity.getOrgId());
            entity.setOrgName(orgVo.getData().getName());
            if (orgVo.getData().getParentId()!=null){
                entity.setParentOrgId(orgVo.getData().getParentId());
            }else {
                entity.setParentOrgId(entity.getOrgId());
            }
        }else{
            throw new BusinessException("网络异常，未获取到项目部信息，请稍后重试！");
        }
        saveOrUpdate(entity, false);
        CauseVO vo = BeanMapper.map(entity, CauseVO.class);
        return vo;
    }

    @Override
    public List<CauseRtVO> querCauseList(QueryWrapper queryWrapper) {
        return baseMapper.querCauseList(queryWrapper);
    }
}
