package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.wzxt.bean.ReviewDetailChangeEntity;
import com.ejianc.business.wzxt.vo.ReviewChangeHisVO;
import com.ejianc.business.wzxt.vo.ReviewDetailChangeHisVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.ReviewDetailChangeHisMapper;
import com.ejianc.business.wzxt.bean.ReviewDetailChangeHisEntity;
import com.ejianc.business.wzxt.service.IReviewDetailChangeHisService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 复核变更记录详情实体
 * 
 * @author generator
 * 
 */
@Service("reviewDetailChangeHisService")
public class ReviewDetailChangeHisServiceImpl extends BaseServiceImpl<ReviewDetailChangeHisMapper, ReviewDetailChangeHisEntity> implements IReviewDetailChangeHisService{

    @Override
    public ReviewChangeHisVO queryDetail(Long id) {
        ReviewDetailChangeHisEntity reviewDetailChangeHisEntity = super.selectById(id);
        ReviewChangeHisVO reviewChangeHisVO = BeanMapper.map(reviewDetailChangeHisEntity, ReviewChangeHisVO.class);

        List<ReviewDetailChangeHisVO> reviewDetailList = reviewChangeHisVO.getReviewDetailList();
        Map<Long, List<ReviewDetailChangeHisVO>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailChangeHisVO::getParentId));
        List<ReviewDetailChangeHisVO> reviewDetailVOS = reviewDetailList.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());

        for (ReviewDetailChangeHisVO reviewDetailVO : reviewDetailVOS){
            List<ReviewDetailChangeHisVO> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        reviewChangeHisVO.setReviewDetailList(reviewDetailVOS);
        return reviewChangeHisVO;
    }
}
