/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.util.ContextHolderUtils;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.Check;
import com.ejianc.business.wzxt.vo.CheckB;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="check")
public class CheckBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TOKEN_URL = "/el/supl/auth/v1/accessToken?appId=6de82f4q&secret=azLc1HUc";
    @Value(value="${smartWeigh.addr}")
    private String SUPPLIER_HTTP;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if (entity.getSaveState() == 0) {
            entity.setSaveState(1);
            this.checkService.saveOrUpdate((Object)entity, false);
            this.logger.info("\u5355\u636e----" + billId + "----\u5df2\u4fdd\u5b58");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------  \u9a8c\u6536\u5355\u63a8\u9001\u4f9b\u65b9  ------------");
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        Check data = this.getCheckHeadVO(entity);
        List<CheckB> bodyList = this.getCheckBodyVOList(entity);
        data.setCheckBList(bodyList);
        String url = this.SUPPLIER_HTTP + "/el/delivery/check/insert";
        String parameterStr = JSONObject.toJSON((Object)data).toString();
        CommonResponse<Object> res = this.doPostHttp(url, parameterStr);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if ("1".equals(entity.getIsConfirm())) {
            this.logger.info("\u5355\u636e----" + billId + "----\u5df2\u4f9b\u65b9\u786e\u8ba4");
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u4f9b\u65b9\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        if (entity.getUseState() == 1) {
            this.logger.info("\u5355\u636e----" + billId + "----\u5df2\u63a8\u9001NC");
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u63a8\u9001NC\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private Check getCheckHeadVO(CheckEntity entity) {
        Check data = new Check();
        data.setPkCheck(String.valueOf(entity.getId()));
        data.setBillcode(entity.getBillCode());
        data.setPkOrg(entity.getOrgSourceId());
        data.setPkProject(entity.getProjectSourceId());
        data.setProjectname(entity.getProjectName());
        data.setPkContractPurchase(entity.getContractId());
        data.setContractPurchaseName(entity.getContractName());
        data.setPkSupplier(entity.getSupplierSourceId());
        data.setSuppliername(entity.getSupplierName());
        data.setChecker(entity.getEmployeeName());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        data.setChecktime(formatter.format(entity.getCheckDate()));
        data.setCarnumber(entity.getLicensePlate());
        data.setIsrequirement("1".equals(entity.getIsRequirement()) ? "Y" : "N");
        data.setIsstandard("1".equals(entity.getIsStandard()) ? "Y" : "N");
        data.setMaterialnumber(entity.getMaterialnumber());
        data.setUnit(entity.getConstruction());
        data.setCheckprocess(entity.getCheckprocess());
        data.setCreator(entity.getCreateUserSourceId());
        data.setVdef1(entity.getCreateUserName());
        data.setCreatorDate(formatter.format(entity.getCreateTime()));
        data.setCheckStatus(2);
        List<AttachmentVO> imgList1 = this.queryListBySourceId(entity.getId(), "BT210125000000004", "imgUpload1");
        String tpurl = imgList1.stream().map(AttachmentVO::getFilePath).collect(Collectors.joining(","));
        data.setTpurl(tpurl);
        List<AttachmentVO> imgList2 = this.queryListBySourceId(entity.getId(), "BT210125000000004", "imgUpload2");
        String sceneurl = imgList2.stream().map(AttachmentVO::getFilePath).collect(Collectors.joining(","));
        data.setSceneurl(sceneurl);
        data.setPkDelivery(String.valueOf(entity.getDeliveryId()));
        data.setSysmark("bjxpt");
        return data;
    }

    private List<CheckB> getCheckBodyVOList(CheckEntity entity) {
        ArrayList<CheckB> bodyList = new ArrayList<CheckB>();
        List<CheckDetailEntity> detailList = entity.getDetailList();
        for (CheckDetailEntity detail : detailList) {
            CheckB body = new CheckB();
            body.setPkCheckB(String.valueOf(detail.getId()));
            body.setPkCheck(String.valueOf(detail.getCheckId()));
            body.setPkMaterial(detail.getMaterialSourceId());
            body.setCode(detail.getMaterialCode());
            body.setName(detail.getMaterialName());
            body.setSpec(detail.getSpec());
            body.setMeasname(detail.getUnit());
            body.setManufacturer(detail.getMaterialManufacturer());
            body.setNumber(this.getDouble(detail.getCheckNumsSum()));
            body.setVat(this.getDouble(detail.getNprice()));
            body.setTax(this.getDouble(detail.getTaxrate()));
            body.setNote(detail.getMemo());
            body.setPkDelivery(String.valueOf(detail.getDeliveryId()));
            body.setPkDeliveryInfo(String.valueOf(detail.getDeliveryDetailId()));
            bodyList.add(body);
        }
        return bodyList;
    }

    private List<AttachmentVO> queryListBySourceId(Long sourceId, String billType, String sourceType) {
        String url = this.BASE_HOST + "ejc-file-web/attachment/queryListBySourceId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceId", String.valueOf(sourceId));
        params.put("billType", billType);
        params.put("sourceType", sourceType);
        try {
            String json = com.ejianc.framework.core.util.HttpTookit.get((String)url, params, (HttpServletRequest)ContextHolderUtils.getRequest());
            this.logger.info("\u8bf7\u6c42\uff1a" + url + "?params={} \u54cd\u5e94\u7ed3\u679c\uff1a{}", params, (Object)json);
            CommonResponse response = (CommonResponse)JSONObject.parseObject((String)json, CommonResponse.class);
            String data = ((JSONObject)response.getData()).getString("data");
            List list = JSONArray.parseArray((String)data, AttachmentVO.class);
            return list;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
            return new ArrayList<AttachmentVO>();
        }
    }

    public CommonResponse<Object> doPostHttp(String url, String parameterStr) {
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            this.logger.info("------------  url\uff1a" + url + "  ------------");
            this.logger.info("------------  \u5165\u53c2\uff1a" + parameterStr + "  ------------");
            String back = HttpTookit.postByJson(url, parameterStr, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                return CommonResponse.success((Object)jsonBack.get((Object)"body"));
            }
            this.logger.error("------------  \u8bf7\u6c42\u5931\u8d25\uff01message = " + jsonBack.getString("message") + "  ------------");
            return CommonResponse.error((String)jsonBack.getString("message"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    private Double getDouble(BigDecimal num) {
        return num != null ? Double.valueOf(num.doubleValue()) : null;
    }
}

