package com.ejianc.business.wzxt.controller;

import java.io.Serializable;

import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.bean.EvaluateEntity;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.vo.EvaluateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.wzxt.bean.ProjectEvaluateEntity;
import com.ejianc.business.wzxt.service.IProjectEvaluateService;
import com.ejianc.business.wzxt.vo.ProjectEvaluateVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 项目对供应商评价表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("projectEvaluate")
public class ProjectEvaluateController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IProjectEvaluateService service;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectEvaluateVO> saveOrUpdate(@RequestBody ProjectEvaluateVO saveorUpdateVO) {
    	ProjectEvaluateEntity entity = BeanMapper.map(saveorUpdateVO, ProjectEvaluateEntity.class);
        CheckEntity checkEntity = checkService.selectById(saveorUpdateVO.getCheckId());
        entity.setCheckBillCode(checkEntity.getBillCode());
        entity.setSupplierId(checkEntity.getSupplierId());
        entity.setSupplierName(checkEntity.getSupplierName());
        entity.setProjectId(checkEntity.getProjectId());
        entity.setProjectName(checkEntity.getProjectName());
        entity.setOrgId(checkEntity.getOrgId());
        entity.setOrgName(checkEntity.getOrgName());
        entity.setEvaluateDate(new Date());
        entity.setEvaluateName(sessionManager.getUserContext().getUserName());
        entity.setEvaluateId(InvocationInfoProxy.getUserid());
        service.saveOrUpdate(entity, false);
    	ProjectEvaluateVO vo = BeanMapper.map(entity, ProjectEvaluateVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectEvaluateVO> queryDetail(Long id) {
    	ProjectEvaluateEntity entity = service.selectById(id);
    	ProjectEvaluateVO vo = BeanMapper.map(entity, ProjectEvaluateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectEvaluateVO> vos) {
        service.removeByIds(vos.stream().map(ProjectEvaluateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectEvaluateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<ProjectEvaluateEntity> page = service.queryPage(param,false);
        IPage<ProjectEvaluateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectEvaluateVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkBillCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("evaluateName");
        fuzzyFields.add("evaluateNote");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<ProjectEvaluateEntity> page = service.queryPage(param,false);
        IPage<ProjectEvaluateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectEvaluateVO.class));
        List<ProjectEvaluateVO> listExport = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            listExport = pageData.getRecords();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("projectEvaluateExport.xlsx", beans, response);
    }

}
