package com.ejianc.business.fbxt.odd.controller;

import java.io.Serializable;

import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fbxt.odd.bean.OddImportEntity;
import com.ejianc.business.fbxt.odd.service.IOddImportService;
import com.ejianc.business.fbxt.odd.vo.OddImportVO;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 零星用工导入实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("oddImport")
public class OddImportController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IOddImportService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddImportVO> saveOrUpdate(@RequestBody OddImportVO saveorUpdateVO) {
    	return service.saveOrUpdate(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddImportVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddImportVO> vos) {
        service.removeByIds(vos.stream().map(OddImportVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddImportVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("importFlag", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage<OddImportEntity> page = service.queryPage(param,false);
        IPage<OddImportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddImportVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "oddImportInfo-import.xlsx", "零星用工清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request, response);
    }

    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("importFlag", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");

        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage<OddImportEntity> pageData = service.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<OddVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), OddVO.class);
            list.forEach(vo -> {
                if (null != vo.getSourceType()) {
                    if (0 == vo.getSourceType()) {
                        vo.setSourceTypeName("参照申请");
                    } else if (1 == vo.getSourceType()) {
                        vo.setSourceTypeName("自制");
                    }
                } else {
                    vo.setSourceTypeName("");
                }
                if (null != vo.getSettleNcFlag()) {
                    if (0 == vo.getSettleNcFlag()) {
                        vo.setSettleNcFlagName("否");
                    } else if (1 == vo.getSettleNcFlag()) {
                        vo.setSettleNcFlagName("是");
                    }
                } else {
                    vo.setSettleNcFlagName("");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState() == null ? 0 : vo.getBillState()).getDescription());
                vo.setZkmny(vo.getZkmny() == null ? BigDecimal.ZERO : vo.getZkmny());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("oddImport-export.xlsx", beans, response);
    }
}
