package com.ejianc.business.fbxt.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.cons.BillCons;
import com.ejianc.business.fbxt.odd.vo.OddApplyVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.ApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddApplyRequest;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fbxt.odd.mapper.OddApplyMapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用工申请实体
 *
 * @author generator
 */
@Service("oddApplyService")
public class OddApplyServiceImpl extends BaseServiceImpl<OddApplyMapper, OddApplyEntity> implements IOddApplyService {
    private static final String ODD_APPLY = "ODD_APPLY";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Value("${openApi.wjOddApplyUrl}")
    private String wjOddApplyUrl;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CommonResponse<OddApplyVO> saveOrUpdate(OddApplyVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddApplyEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveorUpdateVO, OddApplyEntity.class);
            operateType = "edit";
        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ODD_APPLY, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, OddApplyEntity.class);
            operateType = "add";
        }

        CommonResponse<OrgVO> orgVo = orgApi.getOneById(entity.getOrgId());
        if (!orgVo.isSuccess()) {
            return CommonResponse.error("列表查询失败, 查询组织信息失败！");
        }
        if (null != orgVo.getData()) {
            entity.setOrgSourceId(orgVo.getData().getSourceId());
        }
        if(entity.getCropId()!=null){
            CommonResponse<OrgVO> cropVo = orgApi.getOneById(entity.getCropId());
            if (!cropVo.isSuccess()) {
                return CommonResponse.error("列表查询失败, 查询组织信息失败！");
            }
            if (null != cropVo.getData()) {
                entity.setCropSourceId(cropVo.getData().getSourceId());
            }
        }

        entity.setRegisterFlag(0);//未登记
        super.saveOrUpdate(entity, false);
        OddApplyVO vo = BeanMapper.map(entity, OddApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public Boolean applyUsed(ApplyRequest request) {
        if (request.getIsused() != null && request.getIsused() == 0) {
            LambdaUpdateWrapper<OddApplyEntity> tupdateWrapper = new LambdaUpdateWrapper<>();
            tupdateWrapper.set(OddApplyEntity::getRegisterFlag, 0);
            tupdateWrapper.set(OddApplyEntity::getOddId, null);
            tupdateWrapper.eq(OddApplyEntity::getId, request.getPkOddApply());
            super.update(tupdateWrapper);
        } else {
            LambdaUpdateWrapper<OddApplyEntity> tupdateWrapper = new LambdaUpdateWrapper<>();
            tupdateWrapper.set(OddApplyEntity::getRegisterFlag, 1);
            tupdateWrapper.set(OddApplyEntity::getOddId, request.getPkOdd());
            tupdateWrapper.eq(OddApplyEntity::getId, request.getPkOddApply());
            super.update(tupdateWrapper);
        }
        return true;
    }

    @Override
    public Boolean suplcommit(OddApplyRequest request) {
        if (request.getOddStatus() != null && request.getOddStatus() == 1) {//供方存疑
            LambdaUpdateWrapper<OddApplyEntity> tupdateWrapper = new LambdaUpdateWrapper<>();
            tupdateWrapper.set(OddApplyEntity::getPassFlag, 2);// 驳回
            tupdateWrapper.set(OddApplyEntity::getManager, request.getManager());
            tupdateWrapper.set(OddApplyEntity::getManagname, request.getManagname());
            tupdateWrapper.set(OddApplyEntity::getOpinion, request.getOpinion());
            tupdateWrapper.set(OddApplyEntity::getBillState, 0);
            tupdateWrapper.eq(OddApplyEntity::getId, request.getPkOddApply());
            super.update(tupdateWrapper);
        } else {//通过
            LambdaUpdateWrapper<OddApplyEntity> tupdateWrapper = new LambdaUpdateWrapper<>();
            tupdateWrapper.set(OddApplyEntity::getPassFlag, 1);
            tupdateWrapper.set(OddApplyEntity::getManager, request.getManager());
            tupdateWrapper.set(OddApplyEntity::getManagname, request.getManagname());
            tupdateWrapper.set(OddApplyEntity::getOpinion, request.getOpinion());
            tupdateWrapper.eq(OddApplyEntity::getId, request.getPkOddApply());
            super.update(tupdateWrapper);
        }
        // 处理附件，主要是补充附件,先删后增
        String billType = BillCons.APPLY_BILL_TYPE;
        String sourceTypebc = BillCons.APPLY_SOURCE_TYPE_BC;// 补充附件类型
        CommonResponse<List<AttachmentVO>> fileResponse = attachmentApi.queryListBySourceId(request.getPkOddApply(), billType, sourceTypebc, null);
        if (fileResponse.isSuccess() && fileResponse.getData() != null && fileResponse.getData().size() > 0) {
            List<Long> fileIds = fileResponse.getData().stream().map(AttachmentVO::getId).collect(Collectors.toList());
            attachmentApi.delete(StringUtils.join(fileIds, ","));
        }
        List<FileRelation> bcFileList = request.getBcfileList();
        if (bcFileList != null && bcFileList.size() > 0) {
            List<AttachmentVO> fileList = new ArrayList<>();
            for (FileRelation f : bcFileList) {
                AttachmentVO file = new AttachmentVO();
                file.setBillType(billType);
                file.setSourceId(request.getPkOddApply());
                file.setSourceType(sourceTypebc);
                file.setFileName(f.getFileName());
                file.setFilePath(BillCons.APPLY_SUPL+"/"+f.getFilePath());
                file.setUploadUserName(request.getManagname());
                file.setFileSize(10123L);
                fileList.add(file);
            }
            attachmentApi.insertBatch(fileList);
        }
        // 供方传过来的附件也是已经移动过的
        //relationFile(request.getPkOddApply().toString(),request.getBcfileList(),FileBizType.FILE_SUPL_TYPE);
        return true;
    }

    @Override
    public CommonResponse<String> pushOddApply(Map<String, String> headers, OddApplyRequest copy) {
        String url = wjOddApplyUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }
}
