package com.ejianc.business.fbxt.odd.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.fbxt.odd.bean.OddInfoApplyEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 用工申请实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_fbxt_odd_apply")
public class OddApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源id
    @TableField(value="crop_id")
    private Long cropId; // 项目所属组织id
    @TableField(value="crop_source_id")
    private String cropSourceId; // 项目所属组织来源id
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_source_id")
    private String orgSourceId; // 组织来源id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="contract_id")
    private String contractId; // 合同
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供方主键
    @TableField(value="supplier_source_id")
    private String supplierSourceId; // 供方来源id
    @TableField(value="supplier_name")
    private String supplierName; // 供方名称
    @TableField(value="create_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 申请日期
    @TableField(value="use_type")
    private Long useType; // 用工类型，档案
    @TableField(value="belong")
    private Long belong; // 费用归属，档案
    @TableField(value="plan_body")
    private String planBody; // 施工部位
    @TableField(value="use_desc")
    private String useDesc; // 用工内容
    @TableField(value="redirect_flag")
    private Integer redirectFlag; // 是否转扣，0-否，1-是
    @TableField(value="register_flag")
    private Integer registerFlag; // 是否登记，0-否，1-是
    @TableField(value="apply_mny")
    private java.math.BigDecimal applyMny; // 申请金额
    @TableField(value="review_mny")
    private java.math.BigDecimal reviewMny; // 审核金额
    @TableField(value="odd_id")
    private Long oddId; // 用工单主键
    @TableField(value="odd_status")
    private Integer oddStatus; // 暂存状态，0-暂存，1-已提交
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "create_name")
    private String createName; // 申请人姓名
    @TableField(value = "crop_name")
    private String cropName; // 所属公司

    /**
     * 经办人
     */
    @TableField(value = "manager")
    private String manager;
    /**
     * 经办人姓名
     */
    @TableField(value = "managname")
    private String managname;
    /**
     * 意见
     */
    @TableField(value = "opinion")
    private String opinion;
    @TableField(value="pass_flag")
    private Integer passFlag; // 供方是否通过，-1：不需要确认，0-待确认，1-已确认，2-已驳回

    @TableField(value = "odd_apply_source")
    private Integer oddApplySource; // 数据来源，0-新增，1-历史数据

    @TableField(exist=false)
    @SubEntity(serviceName="oddInfoApplyService",pidName = "oddApplyId")
    private List<OddInfoApplyEntity> oddInfoApplyEntities = new ArrayList<>(); // 用工申请清单实体


    public Integer getOddApplySource() {
        return oddApplySource;
    }

    public void setOddApplySource(Integer oddApplySource) {
        this.oddApplySource = oddApplySource;
    }

    public Integer getPassFlag() {
        return passFlag;
    }

    public void setPassFlag(Integer passFlag) {
        this.passFlag = passFlag;
    }

    public String getManager() {
        return manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public String getManagname() {
        return managname;
    }

    public void setManagname(String managname) {
        this.managname = managname;
    }

    public String getOpinion() {
        return opinion;
    }

    public void setOpinion(String opinion) {
        this.opinion = opinion;
    }

    public String getCropName() {
        return cropName;
    }

    public void setCropName(String cropName) {
        this.cropName = cropName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目来源id
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源id
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 项目所属组织id
     */
    public Long getCropId() {
        return cropId;
    }

    /**
     * 项目所属组织id
     */
    public void setCropId(Long cropId) {
        this.cropId = cropId;
    }
    /**
     * 项目所属组织来源id
     */
    public String getCropSourceId() {
        return cropSourceId;
    }

    /**
     * 项目所属组织来源id
     */
    public void setCropSourceId(String cropSourceId) {
        this.cropSourceId = cropSourceId;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织来源id
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源id
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同
     */
    public String getContractId() {
        return contractId;
    }

    /**
     * 合同
     */
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供方主键
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供方主键
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方来源id
     */
    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    /**
     * 供方来源id
     */
    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }
    /**
     * 供方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 申请日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 申请日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 用工类型，档案
     */
    public Long getUseType() {
        return useType;
    }

    /**
     * 用工类型，档案
     */
    public void setUseType(Long useType) {
        this.useType = useType;
    }
    /**
     * 费用归属，档案
     */
    public Long getBelong() {
        return belong;
    }

    /**
     * 费用归属，档案
     */
    public void setBelong(Long belong) {
        this.belong = belong;
    }
    /**
     * 施工部位
     */
    public String getPlanBody() {
        return planBody;
    }

    /**
     * 施工部位
     */
    public void setPlanBody(String planBody) {
        this.planBody = planBody;
    }
    /**
     * 用工内容
     */
    public String getUseDesc() {
        return useDesc;
    }

    /**
     * 用工内容
     */
    public void setUseDesc(String useDesc) {
        this.useDesc = useDesc;
    }
    /**
     * 是否转扣，0-否，1-是
     */
    public Integer getRedirectFlag() {
        return redirectFlag;
    }

    /**
     * 是否转扣，0-否，1-是
     */
    public void setRedirectFlag(Integer redirectFlag) {
        this.redirectFlag = redirectFlag;
    }
    /**
     * 是否登记，0-否，1-是
     */
    public Integer getRegisterFlag() {
        return registerFlag;
    }

    /**
     * 是否登记，0-否，1-是
     */
    public void setRegisterFlag(Integer registerFlag) {
        this.registerFlag = registerFlag;
    }
    /**
     * 申请金额
     */
    public java.math.BigDecimal getApplyMny() {
        return applyMny;
    }

    /**
     * 申请金额
     */
    public void setApplyMny(java.math.BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    /**
     * 审核金额
     */
    public java.math.BigDecimal getReviewMny() {
        return reviewMny;
    }

    /**
     * 审核金额
     */
    public void setReviewMny(java.math.BigDecimal reviewMny) {
        this.reviewMny = reviewMny;
    }
    /**
     * 用工单主键
     */
    public Long getOddId() {
        return oddId;
    }

    /**
     * 用工单主键
     */
    public void setOddId(Long oddId) {
        this.oddId = oddId;
    }
    /**
     * 暂存状态，0-暂存，1-已提交
     */
    public Integer getOddStatus() {
        return oddStatus;
    }

    /**
     * 暂存状态，0-暂存，1-已提交
     */
    public void setOddStatus(Integer oddStatus) {
        this.oddStatus = oddStatus;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 用工申请清单实体
     */
    public List<OddInfoApplyEntity> getOddInfoApplyEntities() {
        return oddInfoApplyEntities;
    }

    /**
     * 用工申请清单实体
     */
    public void setOddInfoApplyEntities(List<OddInfoApplyEntity> oddInfoApplyEntities) {
        this.oddInfoApplyEntities = oddInfoApplyEntities;
    }
}
