package com.ejianc.business.fbxt.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.Enum.BillStatusEnum;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddRedirectVO;
import com.ejianc.business.sync.api.IOddSyncApi;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("odd")
public class OddBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IOddService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOddSyncApi oddSyncApi;
    @Autowired
    private IOddApplyService applyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Value("${common.env.base-host}")
    private String baseHost;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("---------------------------零工审批，提交前回调开始");
        QueryParam param = new QueryParam();
        param.getParams().put("odd_id", new Parameter(QueryParam.EQ, billId));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<OddInfoEntity> oddInfoEntities = oddInfoService.queryList(param, false);
        for (OddInfoEntity oe : oddInfoEntities) {
            oe.setReviewMny(oe.getMny());
            oe.setReviewNum(oe.getNum());
            oe.setReviewPrice(oe.getPrice());
        }
        oddInfoService.saveOrUpdateBatch(oddInfoEntities);
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("---------------------------零工审批，提交后回调开始");
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //0是直审，2是有审批流

        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        // todo
        if (baseHost.contains("9080")) {
            //1是直审，2是有审批流
            logger.info("---------------------------数据同步至nc");

            OddVO oddVO = service.queryDetail(billId);
            com.ejianc.business.sync.vo.OddVO map = BeanMapper.map(oddVO, com.ejianc.business.sync.vo.OddVO.class);

            List<OddInfoVO> oddInfoEntities = oddVO.getOddInfoEntities();
            List<com.ejianc.business.sync.vo.OddInfoVO> list = new ArrayList<>();
            for (OddInfoVO info : oddInfoEntities) {
                List<OddRedirectVO> oddRedirectEntities = info.getOddRedirectEntities();
                List<com.ejianc.business.sync.vo.OddRedirectVO> redirectVO = BeanMapper.mapList(oddRedirectEntities, com.ejianc.business.sync.vo.OddRedirectVO.class);
                com.ejianc.business.sync.vo.OddInfoVO oddInfoVO = BeanMapper.map(info, com.ejianc.business.sync.vo.OddInfoVO.class);
                oddInfoVO.setOddRedirectEntities(redirectVO);
                list.add(oddInfoVO);
            }
            map.setOddInfoEntities(list);
            logger.info("主表来源1：" + oddVO.getOddSource());
            logger.info("主表来源2：" + map.getOddSource());
            map.setOddSource(oddVO.getOddSource());
            CommonResponse<String> response = oddSyncApi.syncOdd(map);
            logger.info("+++++++++++++++++++++++++++数据同步至nc");
            if (response.isSuccess()) {
                OddEntity entity = service.selectById(billId);
                if (entity.getSourceType() == 2) {
                    service.sendMsg(entity, BillStatusEnum.已确认.getCode());
                }
                //service.sendMsg(service.selectById(billId), BillStatusEnum.已确认.getCode());
                return CommonResponse.success();
            } else {
                return CommonResponse.error("数据同步至nc失败");
            }
        } else {
            OddEntity entity = service.selectById(billId);
            if (entity.getSourceType() == 2) {
                service.sendMsg(entity, BillStatusEnum.已确认.getCode());
            }
            return CommonResponse.success();
        }


    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        // todo
        if (baseHost.contains("9080")) {
            //查看nc是否同步
            CommonResponse<Boolean> booleanResponse = oddSyncApi.syncFlag(billId);
            logger.debug("--------：" + booleanResponse.isSuccess());
            logger.debug("--------：" + booleanResponse.getData());
            if (booleanResponse.isSuccess()) {
                if (booleanResponse.getData()) {
                    //数据在NC已结算，无法弃审
                    return CommonResponse.error(booleanResponse.getMsg());
                } else {
                    //删除中间表数据
                    CommonResponse<Boolean> delResponse = oddSyncApi.delSync(billId);
                    logger.debug("+++++++：" + delResponse.isSuccess());
                    logger.debug("+++++++：" + delResponse.getData());
                    if (delResponse.isSuccess()) {
                        OddEntity entity = service.selectById(billId);
                        if (entity.getSourceType() == 2) {// 来源供方申请
                            service.sendMsg(service.selectById(billId), BillStatusEnum.待确认.getCode());
                        }
                        return CommonResponse.success();
                    } else {
                        return CommonResponse.error(delResponse.getMsg());
                    }
                }
            } else {
                return CommonResponse.error(booleanResponse.getMsg());
            }
        } else {
            OddEntity entity = service.selectById(billId);
            if (entity.getSourceType() == 2) {// 来源供方申请
                service.sendMsg(service.selectById(billId), BillStatusEnum.待确认.getCode());
            }
            return CommonResponse.success();
        }

    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
