package com.ejianc.business.fbxt.odd.service.impl;

import com.ejianc.business.fbxt.odd.bean.OddImportInfoEntity;
import com.ejianc.business.fbxt.odd.service.*;
import com.ejianc.business.fbxt.odd.vo.*;
import com.ejianc.business.sync.api.IOddSyncApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service("oddImport") 
public class OddImportBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOddImportService service;

	@Autowired
	private IOddSyncApi oddSyncApi;

	@Autowired
	private IOddImportInfoService infoService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("---------------------------零工导入，提交前回调开始");
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("---------------------------零工导入，提交后回调开始");
		QueryParam param = new QueryParam();
		param.getParams().put("odd_id", new Parameter(QueryParam.EQ, billId));
		param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
		List<OddImportInfoEntity> oddInfoEntities = infoService.queryList(param, false);
		for(OddImportInfoEntity oe : oddInfoEntities){
			oe.setReviewMny(oe.getMny());
			oe.setReviewNum(oe.getNum());
			oe.setReviewPrice(oe.getPrice());
		}
		logger.info("查询的条数：" + oddInfoEntities.size());
		infoService.saveOrUpdateBatch(oddInfoEntities);

		logger.info("---------------------------修改审批金额，提交前回调结束");
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		// 1是直审，2是有审批流

		// 如果审批字段为空则赋值申请字段
		QueryParam param = new QueryParam();
		param.getParams().put("odd_id", new Parameter(QueryParam.EQ, billId));
		param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
		List<OddImportInfoEntity> oddInfoList = infoService.queryList(param, false);
		for(OddImportInfoEntity oe : oddInfoList){
			oe.setReviewMny(oe.getReviewMny() != null ? oe.getReviewMny() : oe.getMny());
			oe.setReviewNum(oe.getReviewNum() != null ? oe.getReviewNum() : oe.getNum());
			oe.setReviewPrice(oe.getReviewPrice() != null ? oe.getReviewPrice() : oe.getPrice());
		}
		infoService.saveOrUpdateBatch(oddInfoList);

		logger.info("---------------------------零工导入数据同步至nc");

		OddImportVO importVO = service.queryDetail(billId);
		OddVO map = BeanMapper.map(importVO, OddVO.class);
		com.ejianc.business.sync.vo.OddVO vo = BeanMapper.map(map, com.ejianc.business.sync.vo.OddVO.class);

		List<OddImportInfoVO> oddInfoEntities = importVO.getInfoVOList();
		List<com.ejianc.business.sync.vo.OddInfoVO> list = new ArrayList<>();
		for (OddImportInfoVO info : oddInfoEntities) {
			com.ejianc.business.sync.vo.OddInfoVO oddInfoVO = BeanMapper.map(info, com.ejianc.business.sync.vo.OddInfoVO.class);
			list.add(oddInfoVO);
		}

		vo.setOddInfoEntities(list);
		logger.info("主表来源1：" + importVO.getOddSource());
		logger.info("主表来源2：" + map.getOddSource());
		vo.setOddSource(importVO.getOddSource());
		CommonResponse<String> response = oddSyncApi.syncOddImport(vo);
		logger.info("+++++++++++++++++++++++++++数据同步至nc");
		if (response.isSuccess()) {
			// todo service.sendMsg(service.selectById(billId), BillStatusEnum.已确认.getCode());
			return CommonResponse.success();
		} else {
			return CommonResponse.error("数据同步至nc失败");
		}

	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//查看nc是否同步
		CommonResponse<Boolean> booleanResponse = oddSyncApi.syncFlag(billId);
		logger.debug("--------："+booleanResponse.isSuccess());
		logger.debug("--------："+booleanResponse.getData());
		if (booleanResponse.isSuccess()) {
			if (booleanResponse.getData()) {
				//数据在NC已结算，无法弃审
				return CommonResponse.error(booleanResponse.getMsg());
			} else {
				//删除中间表数据
				CommonResponse<Boolean> delResponse = oddSyncApi.delSync(billId);
				logger.debug("+++++++："+delResponse.isSuccess());
				logger.debug("+++++++："+delResponse.getData());
				if (delResponse.isSuccess()) {
					// todo service.sendMsg(service.selectById(billId), BillStatusEnum.待确认.getCode());
					return CommonResponse.success();
				} else {
					return CommonResponse.error(delResponse.getMsg());
				}
			}
		} else {
			return CommonResponse.error(booleanResponse.getMsg());
		}

	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
