package com.ejianc.business.fbxt.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.grap.service.IRecordService;
import com.ejianc.business.fbxt.odd.Enum.BillStatusEnum;
import com.ejianc.business.fbxt.odd.bean.*;
import com.ejianc.business.fbxt.odd.cons.BillCons;
import com.ejianc.business.fbxt.odd.service.*;
import com.ejianc.business.fbxt.odd.vo.OddDetailVO;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddRedirectVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.ApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddWriteBackRequest;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fbxt.odd.mapper.OddMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 零星用工实体
 *
 * @author generator
 */
@Service("oddService")
public class OddServiceImpl extends BaseServiceImpl<OddMapper, OddEntity> implements IOddService {
    private static final String ODD_CODE = "ODD_CODE";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOddApplyService oddApplyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Autowired
    private IOddRedirectService redirectService;
    @Autowired
    private IOddInfoApplyService oddInfoApplyService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDefdocApi defdocApi;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    @Value("${openApi.wjOddJobUrl}")
    private String wjOddJobUrl;

    @Value("${openApi.wjOddApplyUsedUrl}")
    private String wjOddApplyUsedUrl;

    @Value("${openApi.wjOddApplyBatchNoUsedUrl}")
    private String wjOddApplyBatchNoUsedUrl;

    @Override
    @Transactional
    public CommonResponse<OddVO> saveOrUpdate(OddVO saveorUpdateVO) {
        //isEnter(saveorUpdateVO.getOddInfoEntities());
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveorUpdateVO, OddEntity.class);
            operateType = "edit";
        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ODD_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            saveorUpdateVO.setOddSource(0);
            entity = BeanMapper.map(saveorUpdateVO, OddEntity.class);
            operateType = "add";
        }

        CommonResponse<OrgVO> cropVo = orgApi.getOneById(entity.getCropId());
        if (!cropVo.isSuccess()) {
            //return CommonResponse.error("列表查询失败, 查询组织信息失败！");
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        if (null != cropVo.getData()) {
            entity.setCropSourceId(cropVo.getData().getSourceId());
        }
        CommonResponse<OrgVO> orgVo = orgApi.getOneById(entity.getOrgId());
        if (!orgVo.isSuccess()) {
            return CommonResponse.error("列表查询失败, 查询组织信息失败！");
        }
        if (null != orgVo.getData()) {
            entity.setOrgSourceId(orgVo.getData().getSourceId());
        }

        List<OddInfoEntity> oddInfoEntities = BeanMapper.mapList(saveorUpdateVO.getOddInfoEntities(), OddInfoEntity.class);  // 获取清单列表实体
        List<Long> fileIds = saveorUpdateVO.getFileIds();                 // 获取实体Odd的所有字段名称
        entity.setImportFlag(0);
        super.saveOrUpdate(entity);                                       // 保存OddEntity实体
        // 保存修订记录
        recordService.saveOrUpdateBatchRecordList(entity.getRecordList(), entity.getId());
        //零星用工自由态即回写 ，暂存不回写  删除时释放
        if (entity.getSourceType() == 0 && entity.getOddStatus() == 1) {      // 零星用工申请单的update功能
            //判断申请单重复
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, entity.getId()));
            queryParam.getParams().put("oddStatus", new Parameter(QueryParam.NE, 0));
            queryParam.getParams().put("oddApplyId", new Parameter(QueryParam.EQ, entity.getOddApplyId()));
            List<OddEntity> oddEntities = super.queryList(queryParam, false);
            if (oddEntities != null && oddEntities.size() > 0) {
//                return CommonResponse.error("该用工申请单已被引用");
                throw new BusinessException("该用工申请单已被引用");
            }
            //回写，如果申请单推送给供方，供方也要
            OddApplyEntity oddApplyEntity = oddApplyService.selectById(entity.getOddApplyId());
            if (oddApplyEntity.getPassFlag() != null && oddApplyEntity.getPassFlag() != -1) {
                // 同步供方
                String url = wjOddApplyUsedUrl;
                ApplyRequest request = new ApplyRequest();
                request.setPkOdd(entity.getId());
                request.setPkOddApply(entity.getOddApplyId());
                request.setIsused(1);
                writeBackApplyToSupl(request, url);
            }
            LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, 1);
            updateWrapper.set(OddApplyEntity::getOddId, entity.getId());
            updateWrapper.eq(OddApplyEntity::getId, entity.getOddApplyId());
            oddApplyService.update(updateWrapper);
        }
        if (fileIds != null && fileIds.size() > 0) {                     // 4、实体字段是否为空的判断，用于关联文件
            fileApi.updateAttachRef(entity.getId(), fileIds);
        }
        saveDetails(oddInfoEntities, entity.getId(), operateType); // 5、saveDetails() 函数，details应该是oddInfo清单项的保存，，还有oddRedirect实体
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("oddId", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<OddRedirectEntity> dddRedirectEntityes = redirectService.queryList(queryParam, false); // 6、查询出转扣实体数据

        if (dddRedirectEntityes != null && dddRedirectEntityes.size() > 0) {
            entity.setRedirectFlag(1);
            BigDecimal zkmny = new BigDecimal("0");             // 7、查询出转扣实体之后，即可计算转扣金额的总和
            for (OddRedirectEntity oddRedirectEntity : dddRedirectEntityes) {
                zkmny = oddRedirectEntity.getMny().add(zkmny);
            }
            entity.setZkmny(zkmny);
        } else {
            entity.setRedirectFlag(0);
        }
        super.saveOrUpdate(entity);
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    private void isEnter(List<OddInfoVO> infoVOList) {
        for (OddInfoVO vo : infoVOList) {
            if (vo.getName() == null || vo.getName().length() <= 0) {
                throw new BusinessException("用工项不能为空");
            }
            if (vo.getNum() == null) {
                throw new BusinessException("清单数量不能为空");
            }
            if (vo.getCode() == null || vo.getCode().length() <= 0) {
                throw new BusinessException("清单编码不能为空");
            }
            if (vo.getInfoUnit() == null || vo.getInfoUnit().length() <= 0) {
                throw new BusinessException("单位不能为空");
            }
            if (vo.getPrice() == null) {
                throw new BusinessException("无税单价不能为空");
            }
            if (vo.getBeginTime() == null) {
                throw new BusinessException("开始时间不能为空");
            }
            if (vo.getEndTime() == null) {
                throw new BusinessException("结束时间不能为空");
            }
        }
    }

    private void saveDetails(List<OddInfoEntity> infoList, Long oddId, String operateType) {
        if ("edit".equals(operateType)) {
            //删除所有
            redirectService.remove(new QueryWrapper<OddRedirectEntity>().eq("odd_id", oddId));
        }
        List<OddRedirectEntity> saveRedirects = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for (OddInfoEntity info : infoList) {
            if ("add".equals(info.getRowState())) {
                info.setOddId(oddId);
                info.setInfoNcFlag(0);
                List<OddRedirectEntity> list = info.getOddRedirectEntities();
                oddInfoService.save(info);

                if (list != null && list.size() > 0) {
                    for (OddRedirectEntity re : list) {
                        re.setInfoId(info.getId());
                        re.setOddId(oddId);
                        re.setId(null);
                        re.setRedirectNcFlag(0);
                        saveRedirects.add(re);
                    }
                }
            } else if ("edit".equals(info.getRowState())) {
                List<OddRedirectEntity> list = info.getOddRedirectEntities();
                oddInfoService.updateById(info);
                if (list != null && list.size() > 0) {
                    for (OddRedirectEntity re : list) {
                        re.setInfoId(info.getId());
                        re.setOddId(oddId);
                        re.setId(null);
                        re.setRedirectNcFlag(0);
                        saveRedirects.add(re);
                    }
                }
            } else if ("del".equals(info.getRowState())) {
                deleteIds.add(info.getId());
            }
        }
        if (saveRedirects.size() > 0) {
            redirectService.saveBatch(saveRedirects);
        }
        if (deleteIds.size() > 0) {
            oddInfoService.removeByIds(deleteIds, false);
        }
    }


    @Override
    public void del(List<OddVO> vos) {
        List<Long> list = vos.stream().map(OddVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, list));
        List<OddEntity> oddEntities = super.queryList(queryParam, false);
        List<Long> ids = new ArrayList<>();
        for (OddEntity entity : oddEntities) {
            if (entity.getSourceType() == 2) {
                throw new BusinessException("供方同步的零工单不允许删除");
            }
            if (entity.getSourceType() == 0) {
                ids.add(entity.getOddApplyId());
            }
        }
        if (ids.size() > 0) {
            LambdaQueryWrapper<OddApplyEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(OddApplyEntity::getDr, 0);
            lambda.in(OddApplyEntity::getId, ids);
            List<OddApplyEntity> applyEntities = oddApplyService.list(lambda);
            List<Long> pkOddApplyList = new ArrayList<>();
            for (OddApplyEntity applyEntity : applyEntities) {
                if (applyEntity.getPassFlag() != null && applyEntity.getPassFlag() != -1) {
                    pkOddApplyList.add(applyEntity.getId());
                }
            }

            LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, 0);
            updateWrapper.set(OddApplyEntity::getOddId, null);
            updateWrapper.in(OddApplyEntity::getId, ids);
            oddApplyService.update(updateWrapper);

            if (pkOddApplyList.size() > 0) {
                // 同步供方
                String url = wjOddApplyBatchNoUsedUrl;
                ApplyRequest request = new ApplyRequest();
                request.setPkOddApplyList(pkOddApplyList);
                writeBackApplyToSupl(request, url);
            }
        }

    }

    @Override
    public OddVO queryDetail(Long id) {
        OddEntity entity = this.selectById(id);
        List<OddInfoEntity> infoEntities = entity.getOddInfoEntities();
        OddVO vo = BeanMapper.map(entity, OddVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List<OddInfoVO> oddInfoVOS = BeanMapper.mapList(infoEntities, OddInfoVO.class);
            QueryParam queryParam = null;
            for (OddInfoVO infovo : oddInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("info_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<OddRedirectEntity> redirectEntities = redirectService.queryList(queryParam, false);
                infovo.setOddRedirectEntities(BeanMapper.mapList(redirectEntities, OddRedirectVO.class));
            }
            vo.setOddInfoEntities(oddInfoVOS);
        }
        return vo;
    }

    @Override
    public List<OddDetailVO> queryDetailsList(Page<OddDetailVO> page, QueryWrapper queryWrapper) {
        return baseMapper.queryDetailsList(page, queryWrapper);
    }

    @Override
    public OddDetailVO queryRedirect(Long infoId) {
        return baseMapper.queryRedirect(infoId);
    }

    //同步nc是否已结算
    @Override
    public CommonResponse<String> settleNc(OddSyncVo vo) {
        List<Long> yinfo = vo.getYinfo();
        List<Long> ninfo = vo.getNinfo();
        List<Long> yredirect = vo.getYredirect();
        List<Long> nredirect = vo.getNredirect();

        if (yinfo != null && yinfo.size() > 0) {
            LambdaUpdateWrapper<OddInfoEntity> yupdateWrapper = new LambdaUpdateWrapper<>();
            yupdateWrapper.set(OddInfoEntity::getInfoNcFlag, 1);
            yupdateWrapper.in(OddInfoEntity::getId, yinfo);
            oddInfoService.update(yupdateWrapper);
        }
        if (ninfo != null && ninfo.size() > 0) {
            LambdaUpdateWrapper<OddInfoEntity> nupdateWrapper = new LambdaUpdateWrapper<>();
            nupdateWrapper.set(OddInfoEntity::getInfoNcFlag, 0);
            nupdateWrapper.in(OddInfoEntity::getId, ninfo);
            oddInfoService.update(nupdateWrapper);
        }
        if (yredirect != null && yredirect.size() > 0) {
            LambdaUpdateWrapper<OddRedirectEntity> tupdateWrapper = new LambdaUpdateWrapper<>();
            tupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, 1);
            tupdateWrapper.in(OddRedirectEntity::getId, yredirect);
            redirectService.update(tupdateWrapper);
        }
        if (nredirect != null && nredirect.size() > 0) {
            LambdaUpdateWrapper<OddRedirectEntity> fupdateWrapper = new LambdaUpdateWrapper<>();
            fupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, 0);
            fupdateWrapper.in(OddRedirectEntity::getId, nredirect);
            redirectService.update(fupdateWrapper);
        }
        //都改成是
        Set<Long> yids = new HashSet<>();
        if (yinfo != null && yinfo.size() > 0) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, yinfo));
            List<OddInfoEntity> oddInfos = oddInfoService.queryList(queryParam, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    yids.add(infoEntity.getOddId());
                }
            }
        }
        if (yredirect != null && yredirect.size() > 0) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, yredirect));
            List<OddRedirectEntity> redirects = redirectService.queryList(queryParam, false);
            if (redirects != null && redirects.size() > 0) {
                for (OddRedirectEntity redirectEntity : redirects) {
                    yids.add(redirectEntity.getOddId());
                }
            }
        }
        if (yids != null && yids.size() > 0) {
            LambdaUpdateWrapper<OddEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddEntity::getSettleNcFlag, 1);
            updateWrapper.in(OddEntity::getId, yids);
            super.update(updateWrapper);
        }

        //看情况改成否
        Set<Long> nids = new HashSet<>();
        if (ninfo != null && ninfo.size() > 0) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ninfo));
            List<OddInfoEntity> oddInfos = oddInfoService.queryList(queryParam, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    nids.add(infoEntity.getOddId());
                }
            }
        }
        if (nredirect != null && nredirect.size() > 0) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, nredirect));
            List<OddRedirectEntity> redirects = redirectService.queryList(queryParam, false);
            if (redirects != null && redirects.size() > 0) {
                for (OddRedirectEntity redirectEntity : redirects) {
                    nids.add(redirectEntity.getOddId());
                }
            }
        }
        if (nids != null && nids.size() > 0) {
            Map<Long, Integer> map = new HashMap<>();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("oddId", new Parameter(QueryParam.IN, nids));
            List<OddInfoEntity> oddInfos = oddInfoService.queryList(queryParam, false);
            List<OddRedirectEntity> redirects = redirectService.queryList(queryParam, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity oi : oddInfos) {
                    if (!map.containsKey(oi.getOddId())) {
                        map.put(oi.getOddId(), 0);
                    }
                    if (oi.getInfoNcFlag() == 1) {//是
                        map.put(oi.getOddId(), map.get(oi.getOddId()) + 1);
                    }
                }
            }
            if (redirects != null && redirects.size() > 0) {
                for (OddRedirectEntity re : redirects) {
                    if (!map.containsKey(re.getOddId())) {
                        map.put(re.getOddId(), 0);
                    }
                    if (re.getRedirectNcFlag() == 1) {//是
                        map.put(re.getOddId(), map.get(re.getOddId()) + 1);
                    }
                }
            }
            List<Long> oddids = new ArrayList<>();
            for (Long key : map.keySet()) {
                if (map.get(key) == 0) {
                    oddids.add(key);
                }
            }
            if (oddids != null && oddids.size() > 0) {
                LambdaUpdateWrapper<OddEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(OddEntity::getSettleNcFlag, 0);
                updateWrapper.in(OddEntity::getId, oddids);
                super.update(updateWrapper);
            }
        }
        return CommonResponse.success("同步成功！");
    }

    @Override
    public Boolean suplInsert(com.ejianc.business.fbxt.odd.vo.sysupl.OddVO request) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String billType = BillCons.ODD_BILL_TYPE;
        // 根据申请单主键查询申请单
        OddApplyEntity applyEntity = oddApplyService.selectById(request.getPkOddApply());
        OddEntity entity = BeanMapper.map(applyEntity, OddEntity.class);
        entity.setId(null);
        entity.setBillCode(request.getOddCode());
        try {
            entity.setCreateDate(sdf.parse(request.getCreateDate()));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        entity.setUseMny(request.getPricesum());
        entity.setReviewMny(request.getSumcheck());
        entity.setSourceType(2);
        entity.setOddApplyId(request.getPkOddApply());
        entity.setOddApplyBillCode(applyEntity.getBillCode());
        entity.setOddStatus(1);// 已提交
        entity.setBillState(0);// 自由态
        entity.setRedirectFlag(request.getRedirectStatus());
        entity.setCreateName(request.getName());
        entity.setSettleNcFlag(0);
        entity.setOddSource(0);
        entity.setImportFlag(0);
        entity.setSourceId(request.getPkOdd());
        entity.setZkmny(request.getSumredirect());
        super.saveOrUpdate(entity);
        // 处理子表，先删后增（防止多次提交的问题）
        List<com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO> oddInfoList = request.getOddInfoList();
        if (oddInfoList != null && oddInfoList.size() > 0) {
            List<OddInfoEntity> oddInfoEntities = new ArrayList<>();
            for (com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO vo : oddInfoList) {
                OddInfoEntity oddInfoEntity = mapInfo(vo, entity.getId());
                oddInfoEntities.add(oddInfoEntity);

                // 处理用工前后附件
                List<FileRelation> befFileList = vo.getBefFileList();
                List<FileRelation> aftFileList = vo.getAftFileList();
                List<AttachmentVO> fileList = new ArrayList<>();
                if (befFileList != null && befFileList.size() > 0) {
                    for (FileRelation f : befFileList) {
                        AttachmentVO file = new AttachmentVO();
                        file.setBillType(billType);
                        file.setSourceId(entity.getId());
                        file.setSourceType("before_" + oddInfoEntity.getFileType());
                        file.setFileName(f.getFileName());
                        file.setFilePath(BillCons.APPLY_SUPL + "/" + f.getFilePath());
                        file.setUploadUserName(null);
                        file.setFileSize(10123L);
                        fileList.add(file);
                    }
                }
                if (aftFileList != null && aftFileList.size() > 0) {
                    for (FileRelation f : aftFileList) {
                        AttachmentVO file = new AttachmentVO();
                        file.setBillType(billType);
                        file.setSourceId(entity.getId());
                        file.setSourceType("after_" + oddInfoEntity.getFileType());
                        file.setFileName(f.getFileName());
                        file.setFilePath(BillCons.APPLY_SUPL + "/" + f.getFilePath());
                        file.setUploadUserName(null);
                        file.setFileSize(10123L);
                        fileList.add(file);
                    }
                }
                if (fileList.size() > 0) {
                    // 保存附件
                    attachmentApi.insertBatch(fileList);
                }
            }
            oddInfoService.saveOrUpdateBatch(oddInfoEntities);
        }

        // 回写申请单是否被引用
        writeBackApply(entity.getId(), entity.getOddApplyId(), true);
        return true;
    }

    @Override
    public Boolean confirmSupply(OddVO request, Integer oddStatus) {
        OddEntity odd = super.selectById(request.getId());
        if (BillStatusEnum.确认驳回.getCode() == oddStatus) {
            // 删除
            odd.setConfirmer(request.getConfirmer());
            odd.setConfirmerName(request.getConfirmerName());
            odd.setConfirmerNote(request.getConfirmerNote());
            writeBackApply(odd.getId(), odd.getOddApplyId(), false);
            // sendToSuplNotice(odd, false); // 改为供方发消息
            super.removeById(request.getId());
            sendMsg(odd, oddStatus);
        } else {
            odd.setConfirmer(request.getConfirmer());
            odd.setConfirmerName(request.getConfirmerName());
            odd.setConfirmerNote(request.getConfirmerNote());
            super.saveOrUpdate(odd);
        }
        return true;
    }

    // 数据结构转换
    private OddInfoEntity mapInfo(com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO vo, Long oddId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        OddInfoEntity res = new OddInfoEntity();
        OddInfoApplyEntity oddInfoApplyEntity = oddInfoApplyService.selectById(vo.getPkApplyInfo());
        res.setId(null);
        res.setOddId(oddId);
        res.setInfoApplyId(vo.getPkApplyInfo());
        res.setName(vo.getInfoName());
        res.setNum(vo.getInfoAmount());
        res.setApplyNum(vo.getApplyAmount()); // 申请数量，申请制单才有
        res.setPrice(vo.getUnitPrice()); // 无税单价
        res.setMny(vo.getSumPrice()); // 金额
        res.setCode(vo.getInfoCode()); // 清单编码
        res.setInfoUnit(vo.getInfoUnit()); // 单位
        res.setReviewNum(vo.getInfoAmountCheck()); // 审核数量
        res.setReviewPrice(vo.getUnitPriceCheck()); // 审核单价
        res.setReviewMny(vo.getSumPriceCheck()); // 审核金额
        res.setSourceType(oddInfoApplyEntity.getSourceType()); // 来源类型，0--引用，1-手工新增
        res.setSourceId(oddInfoApplyEntity.getSourceId()); // 来源主键
        try {
            res.setBeginTime(sdf.parse(vo.getBeginTime())); // 开始时间
            res.setEndTime(sdf.parse(vo.getEndTime())); // 开始时间
        } catch (ParseException e) {
            e.printStackTrace();
        }
        res.setZkcontract(null); // 转扣合同
        res.setZkcorpname(null); // 转扣单位
        res.setSumRedirectMny(BigDecimal.ZERO); // 累计转扣金额
        res.setFileType(String.valueOf(IdWorker.getId())); // 附件唯一标识,这里是为附件做准备
        res.setInfoNcFlag(0); // nc是否结算，0-否，1-是
        return res;
    }

    // 回写申请单是否被引用
    private void writeBackApply(Long pkOdd, Long pkOddApply, boolean isUsed) {
        ApplyRequest request = new ApplyRequest();
        request.setPkOddApply(pkOddApply);
        if (isUsed) {
            request.setPkOdd(pkOdd);
        } else {
            request.setIsused(0);
        }
        oddApplyService.applyUsed(request);
    }

    // 是否引用推送供方
    private void writeBackApplyToSupl(ApplyRequest request, String url) {

        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = oddApplyUsed(headers, request, url);
            logger.info("获取推送供方结果--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }
        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
    }

    @Override
    public void sendMsg(OddEntity odd, Integer oddStatus) {
        OddWriteBackRequest request = new OddWriteBackRequest();
        request.setPkOdd(odd.getSourceId());
        request.setSourceId(odd.getId());
        request.setOddStatus(oddStatus);
        request.setConfirmer(odd.getConfirmer());
        request.setConfirmerName(odd.getConfirmerName());
        request.setConfirmerNote(odd.getConfirmerNote());

        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = pushOddJob(headers, request);
            logger.info("获取推送供方结果--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }
        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
    }

    @Override
    public Map<Long, String> queryDefDoc(String useTypeDefCode) {
        CommonResponse<List<Map<String, Object>>> listCommonResponse = defdocApi.queryDetailListByDefdocCode(useTypeDefCode, null);
        if (listCommonResponse.isSuccess()) {
            List<Map<String, Object>> data = listCommonResponse.getData();
            Map<Long, String> docMap = new HashMap<>();
            for (Map<String, Object> map : data) {
                docMap.put(Long.parseLong(map.get("id").toString()), map.get("name").toString());
            }
            return docMap;
        } else {
            throw new BusinessException("查询自定义档案失败!");
        }
    }

    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
        if (redisTemplate.opsForValue().get("X-Open-Token") != null) {
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------" + redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        } else {
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if ("200".equals(json.get("code").toString())) {
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token, 6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                } else {
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> pushOddJob(Map<String, String> headers, OddWriteBackRequest copy) {
        String url = wjOddJobUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }

    public CommonResponse<String> oddApplyUsed(Map<String, String> headers, ApplyRequest copy, String url) {
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }
}
