/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.grap.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.mapper.GrapMapper;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.vo.GrapVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="grapService")
public class GrapServiceImpl
extends BaseServiceImpl<GrapMapper, GrapEntity>
implements IGrapService {
    private static final String FBXT_GRAP = "HN_FBXT_GRAP";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public GrapVO saveOrUpdate(GrapVO saveorUpdateVO) {
        GrapEntity entity = (GrapEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, GrapEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(FBXT_GRAP, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getCropId() != null) {
            CommonResponse orgVO = this.orgApi.getOneById(entity.getCropId());
            if (!orgVO.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCropSourceId(((OrgVO)orgVO.getData()).getSourceId());
        }
        super.saveOrUpdate((Object)entity, false);
        return (GrapVO)BeanMapper.map((Object)((Object)entity), GrapVO.class);
    }
}

