/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddApplyVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.ApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddApplyRequest;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"oddApply"})
public class OddApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String USE_TYPE_DEF_CODE = "fbxt-use-type";
    @Autowired
    private IOrgApi orgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOddApplyService service;
    @Autowired
    private IOddService oddService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OddApplyVO> saveOrUpdate(@RequestBody OddApplyVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddApplyVO> queryDetail(Long id) {
        OddApplyEntity entity = (OddApplyEntity)((Object)this.service.selectById(id));
        OddApplyVO vo = (OddApplyVO)BeanMapper.map((Object)((Object)entity), OddApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddApplyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OddApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OddApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryzcList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OddApplyVO>> queryzcList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter("eq", (Object)0));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OddApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getcount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> getcount(@RequestBody QueryParam param) {
        CommonResponse<IPage<OddApplyVO>> response = this.queryzcList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)((IPage)response.getData()).getTotal());
    }

    @RequestMapping(value={"/queryApplyRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OddApplyVO>> queryApplyRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        param.setSearchText(searchText);
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("cropName");
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            param.getParams().put("projectId", new Parameter("eq", conditionMap.get("projectId")));
        }
        param.getParams().put("billState", new Parameter("in", billStatus));
        param.getParams().put("registerFlag", new Parameter("eq", (Object)0));
        ArrayList<Integer> passFlag = new ArrayList<Integer>();
        passFlag.add(1);
        passFlag.add(-1);
        param.getParams().put("passFlag", new Parameter("in", passFlag));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OddApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        Map<Long, String> queryDefDoc = this.oddService.queryDefDoc(USE_TYPE_DEF_CODE);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), OddApplyVO.class);
            list.forEach(vo -> {
                if (null != vo.getRegisterFlag()) {
                    if (0 == vo.getRegisterFlag()) {
                        vo.setRegisterFlagName("\u5426");
                    } else if (1 == vo.getRegisterFlag()) {
                        vo.setRegisterFlagName("\u662f");
                    }
                } else {
                    vo.setRegisterFlagName("");
                }
                if (null != vo.getPassFlag()) {
                    if (-1 == vo.getPassFlag()) {
                        vo.setPassFlagName("\u4e0d\u63a8\u9001");
                    } else if (0 == vo.getPassFlag()) {
                        vo.setPassFlagName("\u5f85\u786e\u8ba4");
                    } else if (1 == vo.getPassFlag()) {
                        vo.setPassFlagName("\u5df2\u786e\u8ba4");
                    } else if (2 == vo.getPassFlag()) {
                        vo.setPassFlagName("\u5df2\u9a73\u56de");
                    }
                } else {
                    vo.setPassFlagName("");
                }
                String useTypeName = "";
                if (queryDefDoc.containsKey(vo.getUseType())) {
                    useTypeName = (String)queryDefDoc.get(vo.getUseType());
                }
                vo.setUseTypeName(useTypeName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)(vo.getBillState() == null ? 0 : vo.getBillState())).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("apply-export.xlsx", beans, response);
    }

    @PostMapping(value={"/applyUsed"})
    @ResponseBody
    public CommonResponse<Boolean> applyUsed(@RequestBody ApplyRequest request) {
        return CommonResponse.success((String)"\u66f4\u65b0\u7533\u8bf7\u5355\u662f\u5426\u88ab\u5f15\u7528\u6210\u529f\uff01", (Object)this.service.applyUsed(request));
    }

    @PostMapping(value={"/suplcommit"})
    @ResponseBody
    public CommonResponse<Boolean> suplcommit(@RequestBody OddApplyRequest request) {
        return CommonResponse.success((String)"\u66f4\u65b0\u7533\u8bf7\u5355\u6210\u529f\uff01", (Object)this.service.suplcommit(request));
    }
}

