/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddSetEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoApplyService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.service.IOddSetService;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoApply;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="oddApplyHn")
public class OddApplyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOddApplyService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOddInfoApplyService oddInfoApplyService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IOddService oddService;
    @Autowired
    private IOddSetService oddSetService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        QueryParam param = new QueryParam();
        param.getParams().put("odd_apply_id", new Parameter("eq", (Object)billId));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List oddInfoEntities = this.oddInfoApplyService.queryList(param, false);
        for (OddInfoApplyEntity oe : oddInfoEntities) {
            oe.setReviewMny(oe.getMny());
            oe.setReviewNum(oe.getNum());
            oe.setReviewPrice(oe.getPrice());
        }
        this.oddInfoApplyService.saveOrUpdateBatch(oddInfoEntities);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OddApplyEntity entity = (OddApplyEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OddSetEntity::getOrgId, (Object)entity.getCropId());
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        OddSetEntity setEntity = (OddSetEntity)((Object)this.oddSetService.getOne((Wrapper)queryWrapper));
        Boolean suppStatus = setEntity == null ? false : setEntity.getSuppStatus();
        Boolean confirmStatus = setEntity == null ? false : setEntity.getConfirmStatus();
        if (suppStatus.booleanValue()) {
            HashMap<String, String> headers;
            CommonResponse<String> tokenres;
            String billType = "BT210804000000001";
            String sourceType = "oddapply";
            String sourceTypebc = "oddapplybc";
            OddApplyRequest copy = this.mapOdd(entity);
            ArrayList<OddInfoApply> applies = new ArrayList<OddInfoApply>();
            List<OddInfoApplyEntity> oddInfoApplyEntities = entity.getOddInfoApplyEntities();
            if (oddInfoApplyEntities != null && oddInfoApplyEntities.size() > 0) {
                for (OddInfoApplyEntity info : oddInfoApplyEntities) {
                    applies.add(this.mapInfo(info));
                }
            }
            copy.setOddInfoList(applies);
            ArrayList<FileRelation> gzfileList = new ArrayList<FileRelation>();
            ArrayList<FileRelation> bcfileList = new ArrayList<FileRelation>();
            CommonResponse fileResponse = this.attachmentApi.queryListBySourceId(billId, billType, null, null);
            if (fileResponse.isSuccess() && fileResponse.getData() != null && ((List)fileResponse.getData()).size() > 0) {
                List fileList = (List)fileResponse.getData();
                for (AttachmentVO fileVo : fileList) {
                    FileRelation file = new FileRelation();
                    file.setFileName(fileVo.getFileName());
                    file.setFilePath(fileVo.getFilePath());
                    file.setFileType(fileVo.getFileName().substring(fileVo.getFileName().lastIndexOf(".") + 1, fileVo.getFileName().length()));
                    file.setFileBizPk(billId.toString());
                    file.setDr(Integer.valueOf(0));
                    file.setFileBiz("oddapply");
                    if (fileVo.getSourceType().equals(sourceType)) {
                        file.setBizType("0");
                        gzfileList.add(file);
                    }
                    if (!fileVo.getSourceType().equals(sourceTypebc)) continue;
                    file.setBizType("1");
                    bcfileList.add(file);
                }
            }
            copy.setGzfileList(gzfileList);
            copy.setBcfileList(bcfileList);
            copy.setSysmark("hnxpt");
            if (!confirmStatus.booleanValue()) {
                copy.setOddStatus(Integer.valueOf(5));
            }
            if ((tokenres = this.oddService.getAccessToken(headers = new HashMap<String, String>())).isSuccess()) {
                this.logger.info("hn\u83b7\u53d6\u4f9b\u65b9token--" + headers);
                CommonResponse<String> pushres = this.service.pushOddApply(headers, copy);
                this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
                if (!pushres.isSuccess()) {
                    throw new BusinessException("\u540c\u6b65\u7533\u8bf7\u5355\u5230\u4f9b\u65b9\u5931\u8d25");
                }
            } else {
                throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            LambdaUpdateWrapper tupdateWrapper = new LambdaUpdateWrapper();
            if (confirmStatus.booleanValue()) {
                tupdateWrapper.set(OddApplyEntity::getPassFlag, (Object)0);
            } else {
                tupdateWrapper.set(OddApplyEntity::getPassFlag, (Object)1);
            }
            tupdateWrapper.eq(BaseEntity::getId, (Object)billId);
            this.service.update((Wrapper)tupdateWrapper);
        } else {
            LambdaUpdateWrapper tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddApplyEntity::getPassFlag, (Object)-1);
            tupdateWrapper.eq(BaseEntity::getId, (Object)billId);
            this.service.update((Wrapper)tupdateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u7533\u8bf7\u5355\u6682\u4e0d\u652f\u6301\u5f03\u5ba1");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private OddApplyRequest mapOdd(OddApplyEntity entity) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        OddApplyRequest request = new OddApplyRequest();
        request.setPkOddApply(entity.getId());
        request.setOddCode(entity.getBillCode());
        request.setPkOrg(entity.getCropSourceId());
        request.setPkProject(entity.getProjectSourceId());
        request.setProjectName(entity.getProjectName());
        request.setPkContract(entity.getContractId());
        request.setContractName(entity.getContractName());
        request.setContractCode(entity.getContractCode());
        request.setPkSupplier(entity.getSupplierSourceId());
        request.setSupplierName(entity.getSupplierName());
        request.setCreateDate(sdf.format(entity.getCreateDate()));
        request.setOddType(this.useTypeRef2Integer(entity.getUseType()));
        request.setBelong(this.belong2Integer(entity.getBelong()));
        request.setOddDesc(entity.getUseDesc());
        request.setPkUser(entity.getCreateUserCode());
        request.setName(entity.getCreateName());
        request.setOddStatus(Integer.valueOf(4));
        request.setOddInfoStatus(null);
        request.setPricesum(entity.getApplyMny());
        request.setSumcheck(entity.getReviewMny());
        request.setTs(entity.getCreateTime());
        request.setIsused(entity.getRegisterFlag());
        request.setPkOdd(entity.getOddId());
        request.setManager(entity.getManager());
        request.setManagname(entity.getManagname());
        request.setOpinion(entity.getOpinion());
        request.setIsredirect(entity.getRedirectFlag());
        request.setLocation(entity.getPlanBody());
        return request;
    }

    private OddInfoApply mapInfo(OddInfoApplyEntity entity) {
        OddInfoApply request = new OddInfoApply();
        request.setInfoCode(entity.getCode());
        request.setPkOddinfoApply(entity.getId());
        request.setPkOddApply(entity.getOddApplyId());
        request.setInfoName(entity.getName());
        request.setInfoAmount(null);
        request.setUnitPrice(entity.getPrice());
        request.setInfoUnit(entity.getInfoUnit());
        request.setSumPrice(entity.getMny());
        request.setInfoAmountCheck(null);
        request.setUnitPriceCheck(entity.getReviewPrice());
        request.setSumPriceCheck(entity.getReviewMny());
        request.setBeginTime(null);
        request.setEndTime(null);
        request.setBefUrl(null);
        request.setAftUrl(null);
        request.setApplyAmount(entity.getNum());
        request.setApplyAmountCheck(entity.getReviewNum());
        request.setPkContractinfo(entity.getSourceId());
        return request;
    }

    private Integer useTypeRef2Integer(Long id) {
        Integer useType = null;
        switch (id.toString()) {
            case "1330815360484229121": {
                useType = 0;
                break;
            }
            case "1330815434631135234": {
                useType = 1;
                break;
            }
            case "1330815490885140481": {
                useType = 2;
                break;
            }
            default: {
                useType = null;
            }
        }
        return useType;
    }

    private Integer belong2Integer(Long id) {
        Integer belong = null;
        switch (id.toString()) {
            case "1330815675283521538": {
                belong = 0;
                break;
            }
            case "1330815744443400193": {
                belong = 1;
                break;
            }
            case "1330815794078793730": {
                belong = 2;
                break;
            }
            case "1330815908893671426": {
                belong = 3;
                break;
            }
            case "1330816008898461698": {
                belong = 4;
                break;
            }
            case "1330816053479718913": {
                belong = 5;
                break;
            }
            default: {
                belong = null;
            }
        }
        return belong;
    }
}

