package com.ejianc.business.fbxt.grap.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.vo.GrapVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fbxt.grap.mapper.GrapMapper;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;

/**
 * 进度计量实体
 * 
 * @author generator
 * 
 */
@Service("grapService")
public class GrapServiceImpl extends BaseServiceImpl<GrapMapper, GrapEntity> implements IGrapService{

    private static final String FBXT_GRAP = "HN_FBXT_GRAP";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public GrapVO saveOrUpdate(GrapVO saveorUpdateVO) {
        GrapEntity entity = BeanMapper.map(saveorUpdateVO, GrapEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(FBXT_GRAP, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getCropId() != null){
            //查询项目部上级组织的的来源id
            CommonResponse<OrgVO> orgVO = orgApi.getOneById(entity.getCropId());
            if(!orgVO.isSuccess()) {
                throw new BusinessException("网络异常， 查询组织失败， 请稍后再试");
            }
            entity.setCropSourceId(orgVO.getData().getSourceId());
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, GrapVO.class);
    }
}
