package com.ejianc.business.wzxt.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 发货实体
 *
 * @author generator
 *
 */
 @TableName("ejc_wzxt_delivery")
public class DeliveryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="order_id")
    private java.lang.Long orderId; // 订单主键
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="contract_id")
    private java.lang.String contractId; // 合同主键
    @TableField(value="contract_name")
    private java.lang.String contractName; // 合同名称
    @TableField(value="supplier_id")
    private java.lang.Long supplierId; // 设备供应商
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 供应商名称
    @TableField(value="custom_tenant_id")
    private java.lang.Long customTenantId; // 客户租户ID
    @TableField(value="material_name")
    private java.lang.String materialName; // 物资名称
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 经办人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 经办人名称
    @TableField(value="link_id")
    private java.lang.Long linkId; // 送货人
    @TableField(value="link_name")
    private java.lang.String linkName; // 送货人名称
    @TableField(value="delivery_car_number")
    private java.lang.String deliveryCarNumber; // 车牌号
    @TableField(value="link_telephone")
    private java.lang.String linkTelephone; // 联系人电话
    @TableField(value="delivery_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date deliveryDate; // 送货日期
    @TableField(value="delivery_note")
    private java.lang.String deliveryNote; // 送货要求
    @TableField(value="delivery_address")
    private java.lang.String deliveryAddress; // 送货地址
    @TableField(value="deliver_state")
    private java.lang.Integer deliverState; // 发货状态（0-自由态，1-已发货，2-已验收）
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_source_id")
    private java.lang.String projectSourceId; // 项目来源id
    @TableField(value="order_bill_code")
    private java.lang.String orderBillCode; // 订单单据编号
    @TableField(value="parent_org_id")
    private java.lang.Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_source_id")
    private java.lang.String parentOrgSourceId; // 上级组织来源id
    @TableField(value="org_source_id")
    private java.lang.String orgSourceId; // 组织来源ID
    @TableField(value="supplier_source_id")
    private java.lang.String supplierSourceId; // 供应商来源id
    @TableField(value="smart_status")
    private java.lang.String smartStatus; // 智能称重标识
    @TableField(value="close_status")
    private java.lang.String closeStatus; // 关闭标识
    @TableField(value="platform_type")
    private java.lang.String platformType; // 磅点类型
    @TableField(value="platform_code")
    private java.lang.String platformCode; // 磅点编号
    @TableField(value="history_flag")
    private java.lang.Boolean historyFlag; // 是否历史数据
    @TableField(value="history_id")
    private java.lang.String historyId; // 来源主键
    @TableField(value="history_system")
    private java.lang.String historySystem; // 来源系统
    @TableField(value="def1")
    private java.lang.String def1; // 自定义字段
    @TableField(value="def2")
    private java.lang.String def2; // 自定义字段
    @TableField(value="def3")
    private java.lang.String def3; // 自定义字段
    @TableField(value="def4")
    private java.lang.String def4; // 自定义字段
    @TableField(value="def5")
    private java.lang.String def5; // 自定义字段
    @TableField(value="construction")
    private java.lang.String construction; // 自定义字段
    @TableField(value="material_type")
    private java.lang.Integer materialType; //

    /******  mro add begin     ******/
    @TableField(value="mro_delivery_code")
    private String mroDeliveryCode;

    @TableField(value="plan_id")
    private Long planId;

    @TableField(value="is_confirm")
    private java.lang.Integer isConfirm; // 是否供方确认单价（0-否1-是）

    public Integer getIsConfirm() {
        return isConfirm;
    }

    public void setIsConfirm(Integer isConfirm) {
        this.isConfirm = isConfirm;
    }

    public String getMroDeliveryCode() {
        return mroDeliveryCode;
    }

    public void setMroDeliveryCode(String mroDeliveryCode) {
        this.mroDeliveryCode = mroDeliveryCode;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    /******  mro add end     ******/

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }

    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }

    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }

    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }

    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }

    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    public String getSmartStatus() {
        return smartStatus;
    }

    public void setSmartStatus(String smartStatus) {
        this.smartStatus = smartStatus;
    }

    public String getCloseStatus() {
        return closeStatus;
    }

    public void setCloseStatus(String closeStatus) {
        this.closeStatus = closeStatus;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public Boolean getHistoryFlag() {
        return historyFlag;
    }

    public void setHistoryFlag(Boolean historyFlag) {
        this.historyFlag = historyFlag;
    }

    public String getHistoryId() {
        return historyId;
    }

    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }

    public String getHistorySystem() {
        return historySystem;
    }

    public void setHistorySystem(String historySystem) {
        this.historySystem = historySystem;
    }

    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="deliveryDetailService",pidName = "deliveryId")
    private List<DeliveryDetailEntity> deliveryDetail = new ArrayList<>();

    public List<DeliveryDetailEntity> getDeliveryDetail() {
        return deliveryDetail;
    }

    public void setDeliveryDetail(List<DeliveryDetailEntity> deliveryDetail) {
        this.deliveryDetail = deliveryDetail;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    /**
     * 订单主键
     */
    public java.lang.Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(java.lang.Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 设备供应商
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 客户租户ID
     */
    public java.lang.Long getCustomTenantId() {
        return customTenantId;
    }

    /**
     * 客户租户ID
     */
    public void setCustomTenantId(java.lang.Long customTenantId) {
        this.customTenantId = customTenantId;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 送货人
     */
    public java.lang.Long getLinkId() {
        return linkId;
    }

    /**
     * 送货人
     */
    public void setLinkId(java.lang.Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 送货人名称
     */
    public java.lang.String getLinkName() {
        return linkName;
    }

    /**
     * 送货人名称
     */
    public void setLinkName(java.lang.String linkName) {
        this.linkName = linkName;
    }
    /**
     * 车牌号
     */
    public java.lang.String getDeliveryCarNumber() {
        return deliveryCarNumber;
    }

    /**
     * 车牌号
     */
    public void setDeliveryCarNumber(java.lang.String deliveryCarNumber) {
        this.deliveryCarNumber = deliveryCarNumber;
    }
    /**
     * 联系人电话
     */
    public java.lang.String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(java.lang.String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 送货日期
     */
    public java.util.Date getDeliveryDate() {
        return deliveryDate;
    }

    /**
     * 送货日期
     */
    public void setDeliveryDate(java.util.Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    /**
     * 送货要求
     */
    public java.lang.String getDeliveryNote() {
        return deliveryNote;
    }

    /**
     * 送货要求
     */
    public void setDeliveryNote(java.lang.String deliveryNote) {
        this.deliveryNote = deliveryNote;
    }
    /**
     * 送货地址
     */
    public java.lang.String getDeliveryAddress() {
        return deliveryAddress;
    }

    /**
     * 送货地址
     */
    public void setDeliveryAddress(java.lang.String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }
    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public java.lang.Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public void setDeliverState(java.lang.Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }

}
